/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal.memory;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.AbstractThreadDispatchingHandler;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.Constants;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.ThreadGrouper;
import java.util.function.Consumer;
import jdk.jfr.consumer.RecordedEvent;

public final class ObjectAllocationOutsideTlabHandler
extends AbstractThreadDispatchingHandler {
    private static final String EVENT_NAME = "jdk.ObjectAllocationOutsideTLAB";
    private final LongHistogram histogram;

    public ObjectAllocationOutsideTlabHandler(Meter meter, ThreadGrouper grouper) {
        super(grouper);
        this.histogram = meter.histogramBuilder("process.runtime.jvm.memory.allocation").setDescription("Allocation").setUnit("By").ofLongs().build();
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public JfrFeature getFeature() {
        return JfrFeature.MEMORY_ALLOCATION_METRICS;
    }

    @Override
    public Consumer<RecordedEvent> createPerThreadSummarizer(String threadName) {
        return new PerThreadObjectAllocationOutsideTlabHandler(this.histogram, threadName);
    }

    private static class PerThreadObjectAllocationOutsideTlabHandler
    implements Consumer<RecordedEvent> {
        private static final String ALLOCATION_SIZE = "allocationSize";
        private final LongHistogram histogram;
        private final Attributes attributes;

        public PerThreadObjectAllocationOutsideTlabHandler(LongHistogram histogram, String threadName) {
            this.histogram = histogram;
            this.attributes = Attributes.of(Constants.ATTR_THREAD_NAME, (Object)threadName, Constants.ATTR_ARENA_NAME, (Object)"Main");
        }

        @Override
        public void accept(RecordedEvent ev) {
            this.histogram.record(ev.getLong(ALLOCATION_SIZE), this.attributes);
        }
    }
}

