/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.cost.StatsProvider;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableLayoutResult;
import io.trino.metadata.TableProperties;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.predicate.TupleDomain;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.DomainTranslator;
import io.trino.sql.planner.LayoutConstraintEvaluator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Rules;
import io.trino.sql.planner.iterative.rule.SimplifyExpressions;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PushPredicateIntoTableScan
implements Rule<FilterNode> {
    private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
    private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)));
    private final PlannerContext plannerContext;
    private final TypeAnalyzer typeAnalyzer;

    public PushPredicateIntoTableScan(PlannerContext plannerContext, TypeAnalyzer typeAnalyzer) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isAllowPushdownIntoConnectors(session);
    }

    @Override
    public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
        TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
        Optional<PlanNode> rewritten = PushPredicateIntoTableScan.pushFilterIntoTableScan(filterNode, tableScan, false, context.getSession(), context.getSymbolAllocator(), this.plannerContext, this.typeAnalyzer, context.getStatsProvider(), new DomainTranslator(this.plannerContext));
        if (rewritten.isEmpty() || this.arePlansSame(filterNode, tableScan, rewritten.get())) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(rewritten.get());
    }

    private boolean arePlansSame(FilterNode filter, TableScanNode tableScan, PlanNode rewritten) {
        if (!(rewritten instanceof FilterNode)) {
            return false;
        }
        FilterNode rewrittenFilter = (FilterNode)rewritten;
        if (!Objects.equals(filter.getPredicate(), rewrittenFilter.getPredicate())) {
            return false;
        }
        if (!(rewrittenFilter.getSource() instanceof TableScanNode)) {
            return false;
        }
        TableScanNode rewrittenTableScan = (TableScanNode)rewrittenFilter.getSource();
        return Objects.equals(tableScan.getEnforcedConstraint(), rewrittenTableScan.getEnforcedConstraint()) && Objects.equals(tableScan.getTable(), rewrittenTableScan.getTable());
    }

    public static Optional<PlanNode> pushFilterIntoTableScan(FilterNode filterNode, TableScanNode node, boolean pruneWithPredicateExpression, Session session, SymbolAllocator symbolAllocator, PlannerContext plannerContext, TypeAnalyzer typeAnalyzer, StatsProvider statsProvider, DomainTranslator domainTranslator) {
        boolean precalculateStatistics;
        TupleDomain<ColumnHandle> remainingFilter;
        Optional<TableProperties.TablePartitioning> newTablePartitioning;
        TableHandle newTable;
        Constraint constraint;
        if (!SystemSessionProperties.isAllowPushdownIntoConnectors(session)) {
            return Optional.empty();
        }
        Expression predicate = filterNode.getPredicate();
        Expression deterministicPredicate = ExpressionUtils.filterDeterministicConjuncts(plannerContext.getMetadata(), predicate);
        Expression nonDeterministicPredicate = ExpressionUtils.filterNonDeterministicConjuncts(plannerContext.getMetadata(), predicate);
        DomainTranslator.ExtractionResult decomposedPredicate = DomainTranslator.getExtractionResult(plannerContext, session, deterministicPredicate, symbolAllocator.getTypes());
        TupleDomain newDomain = decomposedPredicate.getTupleDomain().transformKeys(node.getAssignments()::get).intersect(node.getEnforcedConstraint());
        ImmutableBiMap assignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
        if (pruneWithPredicateExpression && !BooleanLiteral.TRUE_LITERAL.equals((Object)decomposedPredicate.getRemainingExpression())) {
            Expression[] expressionArray = new Expression[2];
            expressionArray[0] = deterministicPredicate;
            expressionArray[1] = domainTranslator.toPredicate(session, (TupleDomain<Symbol>)newDomain.simplify().transformKeys(((Map)assignments)::get));
            LayoutConstraintEvaluator evaluator = new LayoutConstraintEvaluator(plannerContext, typeAnalyzer, session, symbolAllocator.getTypes(), node.getAssignments(), ExpressionUtils.combineConjuncts(plannerContext.getMetadata(), expressionArray));
            constraint = new Constraint(newDomain, evaluator::isCandidate, evaluator.getArguments());
        } else {
            constraint = new Constraint(newDomain);
        }
        if (!plannerContext.getMetadata().usesLegacyTableLayouts(session, node.getTable())) {
            if (constraint.predicate().isEmpty() && newDomain.contains(node.getEnforcedConstraint())) {
                Expression resultingPredicate = PushPredicateIntoTableScan.createResultingPredicate(plannerContext, session, symbolAllocator, typeAnalyzer, (Expression)BooleanLiteral.TRUE_LITERAL, nonDeterministicPredicate, decomposedPredicate.getRemainingExpression());
                if (!BooleanLiteral.TRUE_LITERAL.equals((Object)resultingPredicate)) {
                    return Optional.of(new FilterNode(filterNode.getId(), node, resultingPredicate));
                }
                return Optional.of(node);
            }
            if (newDomain.isNone()) {
                return Optional.of(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
            }
            Optional<ConstraintApplicationResult<TableHandle>> result = plannerContext.getMetadata().applyFilter(session, node.getTable(), constraint);
            if (result.isEmpty()) {
                return Optional.empty();
            }
            newTable = (TableHandle)result.get().getHandle();
            TableProperties newTableProperties = plannerContext.getMetadata().getTableProperties(session, newTable);
            newTablePartitioning = newTableProperties.getTablePartitioning();
            if (newTableProperties.getPredicate().isNone()) {
                return Optional.of(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
            }
            remainingFilter = result.get().getRemainingFilter();
            precalculateStatistics = result.get().isPrecalculateStatistics();
        } else {
            Optional<TableLayoutResult> layout = plannerContext.getMetadata().getLayout(session, node.getTable(), constraint, Optional.of((Set)node.getOutputSymbols().stream().map(node.getAssignments()::get).collect(ImmutableSet.toImmutableSet())));
            if (layout.isEmpty() || layout.get().getTableProperties().getPredicate().isNone()) {
                return Optional.of(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
            }
            newTable = layout.get().getNewTableHandle();
            newTablePartitioning = layout.get().getTableProperties().getTablePartitioning();
            remainingFilter = layout.get().getUnenforcedConstraint();
            precalculateStatistics = false;
        }
        PushPredicateIntoTableScan.verifyTablePartitioning(session, plannerContext.getMetadata(), node, newTablePartitioning);
        TableScanNode tableScan = new TableScanNode(node.getId(), newTable, node.getOutputSymbols(), node.getAssignments(), TableLayoutResult.computeEnforced((TupleDomain<ColumnHandle>)newDomain, remainingFilter), Rules.deriveTableStatisticsForPushdown(statsProvider, session, precalculateStatistics, filterNode), node.isUpdateTarget(), node.getUseConnectorNodePartitioning());
        Expression resultingPredicate = PushPredicateIntoTableScan.createResultingPredicate(plannerContext, session, symbolAllocator, typeAnalyzer, domainTranslator.toPredicate(session, (TupleDomain<Symbol>)remainingFilter.transformKeys(((Map)assignments)::get)), nonDeterministicPredicate, decomposedPredicate.getRemainingExpression());
        if (!BooleanLiteral.TRUE_LITERAL.equals((Object)resultingPredicate)) {
            return Optional.of(new FilterNode(filterNode.getId(), tableScan, resultingPredicate));
        }
        return Optional.of(tableScan);
    }

    private static void verifyTablePartitioning(Session session, Metadata metadata, TableScanNode oldTableScan, Optional<TableProperties.TablePartitioning> newTablePartitioning) {
        if (oldTableScan.getUseConnectorNodePartitioning().isEmpty()) {
            return;
        }
        Optional<TableProperties.TablePartitioning> oldTablePartitioning = metadata.getTableProperties(session, oldTableScan.getTable()).getTablePartitioning();
        Verify.verify((boolean)newTablePartitioning.equals(oldTablePartitioning), (String)"Partitioning must not change after predicate is pushed down", (Object[])new Object[0]);
    }

    static Expression createResultingPredicate(PlannerContext plannerContext, Session session, SymbolAllocator symbolAllocator, TypeAnalyzer typeAnalyzer, Expression unenforcedConstraints, Expression nonDeterministicPredicate, Expression remainingDecomposedPredicate) {
        Expression expression = ExpressionUtils.combineConjuncts(plannerContext.getMetadata(), unenforcedConstraints, nonDeterministicPredicate, remainingDecomposedPredicate);
        expression = SimplifyExpressions.rewrite(expression, session, symbolAllocator, plannerContext, typeAnalyzer);
        return expression;
    }
}

