/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.metadata.InsertTableHandle;
import io.trino.metadata.OutputTableHandle;
import io.trino.metadata.TableExecuteHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.split.PageSinkProvider;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PageSinkManager
implements PageSinkProvider {
    private final ConcurrentMap<CatalogName, ConnectorPageSinkProvider> pageSinkProviders = new ConcurrentHashMap<CatalogName, ConnectorPageSinkProvider>();

    public void addConnectorPageSinkProvider(CatalogName catalogName, ConnectorPageSinkProvider pageSinkProvider) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
        Preconditions.checkState((this.pageSinkProviders.put(catalogName, pageSinkProvider) == null ? 1 : 0) != 0, (String)"PageSinkProvider for connector '%s' is already registered", (Object)catalogName);
    }

    public void removeConnectorPageSinkProvider(CatalogName catalogName) {
        this.pageSinkProviders.remove(catalogName);
    }

    @Override
    public ConnectorPageSink createPageSink(Session session, OutputTableHandle tableHandle) {
        ConnectorSession connectorSession = session.toConnectorSession(tableHandle.getCatalogName());
        return this.providerFor(tableHandle.getCatalogName()).createPageSink(tableHandle.getTransactionHandle(), connectorSession, tableHandle.getConnectorHandle());
    }

    @Override
    public ConnectorPageSink createPageSink(Session session, InsertTableHandle tableHandle) {
        ConnectorSession connectorSession = session.toConnectorSession(tableHandle.getCatalogName());
        return this.providerFor(tableHandle.getCatalogName()).createPageSink(tableHandle.getTransactionHandle(), connectorSession, tableHandle.getConnectorHandle());
    }

    @Override
    public ConnectorPageSink createPageSink(Session session, TableExecuteHandle tableHandle) {
        ConnectorSession connectorSession = session.toConnectorSession(tableHandle.getCatalogName());
        return this.providerFor(tableHandle.getCatalogName()).createPageSink(tableHandle.getTransactionHandle(), connectorSession, tableHandle.getConnectorHandle());
    }

    private ConnectorPageSinkProvider providerFor(CatalogName catalogName) {
        ConnectorPageSinkProvider provider = (ConnectorPageSinkProvider)this.pageSinkProviders.get(catalogName);
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (String)"No page sink provider for catalog '%s'", (Object)catalogName.getCatalogName());
        return provider;
    }
}

