/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.SessionRepresentation;
import io.trino.execution.TaskSource;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.spi.predicate.Domain;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.plan.DynamicFilterId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TaskUpdateRequest {
    private final SessionRepresentation session;
    private final Map<String, String> extraCredentials;
    private final Optional<PlanFragment> fragment;
    private final List<TaskSource> sources;
    private final OutputBuffers outputIds;
    private final Map<DynamicFilterId, Domain> dynamicFilterDomains;

    @JsonCreator
    public TaskUpdateRequest(@JsonProperty(value="session") SessionRepresentation session, @JsonProperty(value="extraCredentials") Map<String, String> extraCredentials, @JsonProperty(value="fragment") Optional<PlanFragment> fragment, @JsonProperty(value="sources") List<TaskSource> sources, @JsonProperty(value="outputIds") OutputBuffers outputIds, @JsonProperty(value="dynamicFilterDomains") Map<DynamicFilterId, Domain> dynamicFilterDomains) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(extraCredentials, "extraCredentials is null");
        Objects.requireNonNull(fragment, "fragment is null");
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(outputIds, "outputIds is null");
        Objects.requireNonNull(dynamicFilterDomains, "dynamicFilterDomains is null");
        this.session = session;
        this.extraCredentials = extraCredentials;
        this.fragment = fragment;
        this.sources = ImmutableList.copyOf(sources);
        this.outputIds = outputIds;
        this.dynamicFilterDomains = dynamicFilterDomains;
    }

    @JsonProperty
    public SessionRepresentation getSession() {
        return this.session;
    }

    @JsonProperty
    public Map<String, String> getExtraCredentials() {
        return this.extraCredentials;
    }

    @JsonProperty
    public Optional<PlanFragment> getFragment() {
        return this.fragment;
    }

    @JsonProperty
    public List<TaskSource> getSources() {
        return this.sources;
    }

    @JsonProperty
    public OutputBuffers getOutputIds() {
        return this.outputIds;
    }

    @JsonProperty
    public Map<DynamicFilterId, Domain> getDynamicFilterDomains() {
        return this.dynamicFilterDomains;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("session", (Object)this.session).add("extraCredentials", this.extraCredentials.keySet()).add("fragment", this.fragment).add("sources", this.sources).add("outputIds", (Object)this.outputIds).add("dynamicFilterDomains", this.dynamicFilterDomains).toString();
    }
}

