/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;

public final class HmacFunctions {
    private HmacFunctions() {
    }

    @Description(value="Compute HMAC with MD5")
    @ScalarFunction
    @SqlType(value="varbinary")
    public static Slice hmacMd5(@SqlType(value="varbinary") Slice slice, @SqlType(value="varbinary") Slice key) {
        return HmacFunctions.computeHash(Hashing.hmacMd5((byte[])key.getBytes()), slice);
    }

    @Description(value="Compute HMAC with SHA1")
    @ScalarFunction
    @SqlType(value="varbinary")
    public static Slice hmacSha1(@SqlType(value="varbinary") Slice slice, @SqlType(value="varbinary") Slice key) {
        return HmacFunctions.computeHash(Hashing.hmacSha1((byte[])key.getBytes()), slice);
    }

    @Description(value="Compute HMAC with SHA256")
    @ScalarFunction
    @SqlType(value="varbinary")
    public static Slice hmacSha256(@SqlType(value="varbinary") Slice slice, @SqlType(value="varbinary") Slice key) {
        return HmacFunctions.computeHash(Hashing.hmacSha256((byte[])key.getBytes()), slice);
    }

    @Description(value="Compute HMAC with SHA512")
    @ScalarFunction
    @SqlType(value="varbinary")
    public static Slice hmacSha512(@SqlType(value="varbinary") Slice slice, @SqlType(value="varbinary") Slice key) {
        return HmacFunctions.computeHash(Hashing.hmacSha512((byte[])key.getBytes()), slice);
    }

    static Slice computeHash(HashFunction hash, Slice data) {
        HashCode result = data.hasByteArray() ? hash.hashBytes(data.byteArray(), data.byteArrayOffset(), data.length()) : hash.hashBytes(data.getBytes());
        return Slices.wrappedBuffer((byte[])result.asBytes());
    }
}

