/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.PageSplitterUtil;
import io.trino.execution.buffer.PagesSerde;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.operator.OperatorContext;
import io.trino.operator.PartitionFunction;
import io.trino.operator.output.PagePartitioner;
import io.trino.operator.output.PartitionedOutputOperator;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class DefaultPagePartitioner
implements PagePartitioner {
    private final OutputBuffer outputBuffer;
    private final Type[] sourceTypes;
    private final PartitionFunction partitionFunction;
    private final int[] partitionChannels;
    @Nullable
    private final Block[] partitionConstantBlocks;
    private final PagesSerde serde;
    private final PageBuilder[] pageBuilders;
    private final boolean replicatesAnyRow;
    private final int nullChannel;
    private final AtomicLong rowsAdded = new AtomicLong();
    private final AtomicLong pagesAdded = new AtomicLong();
    private boolean hasAnyRowBeenReplicated;
    private final OperatorContext operatorContext;

    public DefaultPagePartitioner(PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<NullableValue>> partitionConstants, boolean replicatesAnyRow, OptionalInt nullChannel, OutputBuffer outputBuffer, PagesSerdeFactory serdeFactory, List<Type> sourceTypes, DataSize maxMemory, OperatorContext operatorContext) {
        this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
        this.partitionChannels = Ints.toArray((Collection)Objects.requireNonNull(partitionChannels, "partitionChannels is null"));
        Block[] partitionConstantBlocks = (Block[])Objects.requireNonNull(partitionConstants, "partitionConstants is null").stream().map(constant -> constant.map(NullableValue::asBlock).orElse(null)).toArray(Block[]::new);
        this.partitionConstantBlocks = Arrays.stream(partitionConstantBlocks).anyMatch(Objects::nonNull) ? partitionConstantBlocks : null;
        this.replicatesAnyRow = replicatesAnyRow;
        this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null").orElse(-1);
        this.outputBuffer = Objects.requireNonNull(outputBuffer, "outputBuffer is null");
        this.sourceTypes = Objects.requireNonNull(sourceTypes, "sourceTypes is null").toArray(new Type[0]);
        this.serde = Objects.requireNonNull(serdeFactory, "serdeFactory is null").createPagesSerde();
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        for (int i = 0; i < this.partitionChannels.length; ++i) {
            if (this.partitionChannels[i] >= 0) continue;
            Preconditions.checkArgument((this.partitionConstantBlocks != null && this.partitionConstantBlocks[i] != null ? 1 : 0) != 0, (String)"Expected constant for partitioning channel %s, but none was found", (int)i);
        }
        int partitionCount = partitionFunction.getPartitionCount();
        int pageSize = Math.toIntExact(Math.min(0x100000L, maxMemory.toBytes() / (long)partitionCount));
        pageSize = Math.max(1, pageSize);
        this.pageBuilders = new PageBuilder[partitionCount];
        for (int i = 0; i < partitionCount; ++i) {
            this.pageBuilders[i] = PageBuilder.withMaxPageSize((int)pageSize, sourceTypes);
        }
    }

    @Override
    public ListenableFuture<Void> isFull() {
        return this.outputBuffer.isFull();
    }

    @Override
    public long getSizeInBytes() {
        long sizeInBytes = 0L;
        for (PageBuilder pageBuilder : this.pageBuilders) {
            sizeInBytes += pageBuilder.getSizeInBytes();
        }
        return sizeInBytes;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long sizeInBytes = 0L;
        for (PageBuilder pageBuilder : this.pageBuilders) {
            sizeInBytes += pageBuilder.getRetainedSizeInBytes();
        }
        return sizeInBytes;
    }

    @Override
    public Supplier<PartitionedOutputOperator.PartitionedOutputInfo> getOperatorInfoSupplier() {
        return DefaultPagePartitioner.createPartitionedOutputOperatorInfoSupplier(this.rowsAdded, this.pagesAdded, this.outputBuffer);
    }

    private static Supplier<PartitionedOutputOperator.PartitionedOutputInfo> createPartitionedOutputOperatorInfoSupplier(AtomicLong rowsAdded, AtomicLong pagesAdded, OutputBuffer outputBuffer) {
        Objects.requireNonNull(rowsAdded, "rowsAdded is null");
        Objects.requireNonNull(pagesAdded, "pagesAdded is null");
        Objects.requireNonNull(outputBuffer, "outputBuffer is null");
        return () -> new PartitionedOutputOperator.PartitionedOutputInfo(rowsAdded.get(), pagesAdded.get(), outputBuffer.getPeakMemoryUsage());
    }

    @Override
    public void partitionPage(Page page) {
        int position;
        Objects.requireNonNull(page, "page is null");
        if (page.getPositionCount() == 0) {
            return;
        }
        if (this.replicatesAnyRow && !this.hasAnyRowBeenReplicated) {
            for (PageBuilder pageBuilder : this.pageBuilders) {
                this.appendRow(pageBuilder, page, 0);
            }
            this.hasAnyRowBeenReplicated = true;
            position = 1;
        } else {
            position = 0;
        }
        Page partitionFunctionArgs = this.getPartitionFunctionArguments(page);
        if (this.nullChannel >= 0 && page.getBlock(this.nullChannel).mayHaveNull()) {
            Block nullsBlock = page.getBlock(this.nullChannel);
            while (position < page.getPositionCount()) {
                if (nullsBlock.isNull(position)) {
                    for (PageBuilder pageBuilder : this.pageBuilders) {
                        this.appendRow(pageBuilder, page, position);
                    }
                } else {
                    int partition = this.partitionFunction.getPartition(partitionFunctionArgs, position);
                    this.appendRow(this.pageBuilders[partition], page, position);
                }
                ++position;
            }
        } else {
            while (position < page.getPositionCount()) {
                int partition = this.partitionFunction.getPartition(partitionFunctionArgs, position);
                this.appendRow(this.pageBuilders[partition], page, position);
                ++position;
            }
        }
        this.flush(false);
    }

    private Page getPartitionFunctionArguments(Page page) {
        if (this.partitionConstantBlocks == null) {
            return page.getColumns(this.partitionChannels);
        }
        Block[] blocks = new Block[this.partitionChannels.length];
        for (int i = 0; i < blocks.length; ++i) {
            int channel = this.partitionChannels[i];
            blocks[i] = channel < 0 ? new RunLengthEncodedBlock(this.partitionConstantBlocks[i], page.getPositionCount()) : page.getBlock(channel);
        }
        return new Page(page.getPositionCount(), blocks);
    }

    private void appendRow(PageBuilder pageBuilder, Page page, int position) {
        pageBuilder.declarePosition();
        for (int channel = 0; channel < this.sourceTypes.length; ++channel) {
            Type type = this.sourceTypes[channel];
            type.appendTo(page.getBlock(channel), position, pageBuilder.getBlockBuilder(channel));
        }
    }

    @Override
    public void flush(boolean force) {
        try (PagesSerde.PagesSerdeContext context = this.serde.newContext();){
            for (int partition = 0; partition < this.pageBuilders.length; ++partition) {
                PageBuilder partitionPageBuilder = this.pageBuilders[partition];
                if (partitionPageBuilder.isEmpty() || !force && !partitionPageBuilder.isFull()) continue;
                Page pagePartition = partitionPageBuilder.build();
                partitionPageBuilder.reset();
                this.operatorContext.recordOutput(pagePartition.getSizeInBytes(), pagePartition.getPositionCount());
                this.outputBuffer.enqueue(partition, this.splitAndSerializePage(context, pagePartition));
                this.pagesAdded.incrementAndGet();
                this.rowsAdded.addAndGet(pagePartition.getPositionCount());
            }
        }
    }

    private List<Slice> splitAndSerializePage(PagesSerde.PagesSerdeContext context, Page page) {
        List<Page> split = PageSplitterUtil.splitPage(page, 0x100000L);
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)split.size());
        for (Page p : split) {
            builder.add((Object)this.serde.serialize(context, p));
        }
        return builder.build();
    }
}

