/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import java.util.function.LongConsumer;

public final class PageUtils {
    private PageUtils() {
    }

    public static void recordMaterializedBytes(Page page, LongConsumer sizeInBytesConsumer) {
        long loadedBlocksSizeInBytes = 0L;
        for (int i = 0; i < page.getChannelCount(); ++i) {
            Block block = page.getBlock(i);
            long initialSize = block.getSizeInBytes();
            loadedBlocksSizeInBytes += initialSize;
            LazyBlock.listenForLoads((Block)block, loadedBlock -> sizeInBytesConsumer.accept(loadedBlock.getSizeInBytes()));
        }
        if (loadedBlocksSizeInBytes > 0L) {
            sizeInBytesConsumer.accept(loadedBlocksSizeInBytes);
        }
    }
}

