/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.client.ClientCapabilities;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.SqlPath;
import io.trino.sql.SqlPathElement;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SetPath;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class SetPathTask
implements DataDefinitionTask<SetPath> {
    private final Metadata metadata;

    @Inject
    public SetPathTask(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public String getName() {
        return "SET PATH";
    }

    @Override
    public ListenableFuture<Void> execute(SetPath statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        if (!session.getClientCapabilities().contains(ClientCapabilities.PATH.toString())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "SET PATH not supported by client");
        }
        SqlPath sqlPath = new SqlPath(Optional.of(statement.getPathSpecification().toString()));
        for (SqlPathElement element : sqlPath.getParsedPath()) {
            if (element.getCatalog().isEmpty() && session.getCatalog().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_CATALOG_NAME, (Node)statement, "Catalog must be specified for each path element when session catalog is not set", new Object[0]);
            }
            element.getCatalog().ifPresent(catalog -> {
                String catalogName = catalog.getValue().toLowerCase(Locale.ENGLISH);
                MetadataUtil.getRequiredCatalogHandle(this.metadata, session, (Node)statement, catalogName);
            });
        }
        stateMachine.setSetPath(sqlPath.toString());
        return Futures.immediateVoidFuture();
    }
}

