/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;

class EntryCountEstimator {
    private EntryCountEstimator() {
    }

    static int estimateEntryCountByBytesSize(int maxEntries, long maxSizeBytes, Position readPosition, ManagedLedgerImpl ml) {
        LedgerHandle currentLedger = ml.getCurrentLedger();
        Long lastLedgerId = currentLedger != null ? Long.valueOf(currentLedger.getId()) : null;
        long lastLedgerTotalSize = ml.getCurrentLedgerSize();
        long lastLedgerTotalEntries = ml.getCurrentLedgerEntries();
        return EntryCountEstimator.internalEstimateEntryCountByBytesSize(maxEntries, maxSizeBytes, readPosition, ml.getLedgersInfo(), lastLedgerId, lastLedgerTotalEntries, lastLedgerTotalSize);
    }

    static int internalEstimateEntryCountByBytesSize(int maxEntries, long maxSizeBytes, Position readPosition, NavigableMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgersInfo, Long lastLedgerId, long lastLedgerTotalEntries, long lastLedgerTotalSize) {
        if (maxSizeBytes <= 0L) {
            return 1;
        }
        if (maxSizeBytes == Long.MAX_VALUE) {
            return maxEntries;
        }
        if (ledgersInfo.isEmpty()) {
            return 1;
        }
        try {
            readPosition = EntryCountEstimator.adjustReadPosition(readPosition, ledgersInfo, lastLedgerId, lastLedgerTotalEntries);
        }
        catch (NoSuchElementException e) {
            return 1;
        }
        long estimatedEntryCount = 0L;
        long remainingBytesSize = maxSizeBytes;
        long currentAvgSize = 0L;
        Collection ledgersAfterReadPosition = ledgersInfo.tailMap(readPosition.getLedgerId(), true).values();
        for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo : ledgersAfterReadPosition) {
            if (remainingBytesSize <= 0L || estimatedEntryCount >= (long)maxEntries) break;
            long ledgerId = ledgerInfo.getLedgerId();
            long ledgerTotalSize = ledgerInfo.getSize();
            long ledgerTotalEntries = ledgerInfo.getEntries();
            if (lastLedgerId != null && ledgerId == lastLedgerId && lastLedgerTotalSize > 0L && lastLedgerTotalEntries > 0L) {
                ledgerTotalSize = lastLedgerTotalSize;
                ledgerTotalEntries = lastLedgerTotalEntries;
            }
            if (ledgerTotalEntries == 0L || ledgerTotalSize == 0L) continue;
            currentAvgSize = Math.max(1L, ledgerTotalSize / ledgerTotalEntries) + 64L;
            long ledgerTotalSizeWithBkOverhead = ledgerTotalSize + ledgerTotalEntries * 64L;
            if (remainingBytesSize < ledgerTotalSizeWithBkOverhead || readPosition.getLedgerId() == ledgerId && readPosition.getEntryId() > 0L) {
                long entryCount = readPosition.getLedgerId() == ledgerId && readPosition.getEntryId() > 0L ? Math.max(ledgerTotalEntries - readPosition.getEntryId(), 1L) : ledgerTotalEntries;
                long entriesToRead = Math.min(Math.max(1L, remainingBytesSize / currentAvgSize), entryCount);
                estimatedEntryCount += entriesToRead;
                remainingBytesSize -= entriesToRead * currentAvgSize;
                continue;
            }
            estimatedEntryCount += ledgerTotalEntries;
            remainingBytesSize -= ledgerTotalSizeWithBkOverhead;
        }
        if (remainingBytesSize > 0L && estimatedEntryCount < (long)maxEntries) {
            if (currentAvgSize == 0L) {
                Collection ledgersBeforeReadPosition = ledgersInfo.headMap(readPosition.getLedgerId(), false).descendingMap().values();
                for (MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo : ledgersBeforeReadPosition) {
                    long ledgerTotalSize = ledgerInfo.getSize();
                    long ledgerTotalEntries = ledgerInfo.getEntries();
                    if (ledgerTotalEntries == 0L || ledgerTotalSize == 0L) continue;
                    currentAvgSize = Math.max(1L, ledgerTotalSize / ledgerTotalEntries) + 64L;
                    break;
                }
            }
            if (currentAvgSize > 0L) {
                estimatedEntryCount += remainingBytesSize / currentAvgSize;
            }
        }
        return Math.max((int)Math.min(estimatedEntryCount, (long)maxEntries), 1);
    }

    private static Position adjustReadPosition(Position readPosition, NavigableMap<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgersInfo, Long lastLedgerId, long lastLedgerTotalEntries) {
        Map.Entry<Long, MLDataFormats.ManagedLedgerInfo.LedgerInfo> lastEntry;
        if (lastLedgerId != null && readPosition.getLedgerId() > lastLedgerId) {
            return PositionImpl.get(lastLedgerId, Math.max(lastLedgerTotalEntries - 1L, 0L));
        }
        long lastKey = (Long)ledgersInfo.lastKey();
        if (lastLedgerId == null && readPosition.getLedgerId() > lastKey && (lastEntry = ledgersInfo.lastEntry()) != null && lastEntry.getKey() == lastKey) {
            return PositionImpl.get(lastEntry.getKey(), Math.max(lastEntry.getValue().getEntries() - 1L, 0L));
        }
        long firstKey = (Long)ledgersInfo.firstKey();
        if (readPosition.getLedgerId() < firstKey) {
            return PositionImpl.get(firstKey, 0L);
        }
        return readPosition;
    }
}

