/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;

public class MergeLimitWithDistinct
implements Rule<LimitNode> {
    private static final Capture<AggregationNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().matching(limit -> !limit.isWithTies()).with(Patterns.Limit.requiresPreSortedInputs().equalTo((Object)false)).with(Patterns.source().matching(Patterns.aggregation().capturedAs(CHILD).matching(AggregationNode::producesDistinctRows)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        AggregationNode child = (AggregationNode)captures.get(CHILD);
        return Rule.Result.ofPlanNode(new DistinctLimitNode(parent.getId(), child.getSource(), parent.getCount(), false, child.getGroupingKeys(), child.getHashSymbol()));
    }
}

