/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.operator.join.LookupSource;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class SpilledLookupSourceHandle {
    @GuardedBy(value="this")
    private State state = State.SPILLED;
    private final SettableFuture<Void> unspillingRequested = SettableFuture.create();
    @Nullable
    @GuardedBy(value="this")
    private SettableFuture<Supplier<LookupSource>> unspilledLookupSource;
    private final SettableFuture<Void> disposeRequested = SettableFuture.create();
    private final SettableFuture<Void> disposeCompleted = SettableFuture.create();
    private final ListenableFuture<Void> unspillingOrDisposeRequested = MoreFutures.whenAnyComplete((Iterable)ImmutableList.of(this.unspillingRequested, this.disposeRequested));

    SpilledLookupSourceHandle() {
    }

    public SettableFuture<Void> getUnspillingRequested() {
        return this.unspillingRequested;
    }

    public synchronized ListenableFuture<Supplier<LookupSource>> getLookupSource() {
        this.assertState(State.SPILLED);
        this.unspillingRequested.set(null);
        this.setState(State.UNSPILLING);
        Preconditions.checkState((this.unspilledLookupSource == null ? 1 : 0) != 0, (Object)"unspilledLookupSource already set");
        this.unspilledLookupSource = SettableFuture.create();
        return this.unspilledLookupSource;
    }

    public synchronized void setLookupSource(Supplier<LookupSource> lookupSource) {
        Objects.requireNonNull(lookupSource, "lookupSource is null");
        if (this.state == State.DISPOSE_REQUESTED) {
            return;
        }
        this.assertState(State.UNSPILLING);
        Preconditions.checkState((this.unspilledLookupSource != null ? 1 : 0) != 0, (Object)"unspilledLookupSource not set");
        this.unspilledLookupSource.set(lookupSource);
        this.unspilledLookupSource = null;
        this.setState(State.PRODUCED);
    }

    public synchronized void dispose() {
        this.disposeRequested.set(null);
        this.unspilledLookupSource = null;
        this.setState(State.DISPOSE_REQUESTED);
    }

    public SettableFuture<Void> getDisposeRequested() {
        return this.disposeRequested;
    }

    public synchronized void setDisposeCompleted() {
        this.disposeCompleted.set(null);
    }

    public SettableFuture<Void> getDisposeCompleted() {
        return this.disposeCompleted;
    }

    public ListenableFuture<Void> getUnspillingOrDisposeRequested() {
        return this.unspillingOrDisposeRequested;
    }

    @GuardedBy(value="this")
    private void assertState(State expectedState) {
        State currentState = this.state;
        Preconditions.checkState((currentState == expectedState ? 1 : 0) != 0, (String)"Expected state %s, but state is %s", (Object)((Object)expectedState), (Object)((Object)currentState));
    }

    @GuardedBy(value="this")
    private void setState(State newState) {
        this.state = Objects.requireNonNull(newState, "newState is null");
    }

    private static enum State {
        SPILLED,
        UNSPILLING,
        PRODUCED,
        DISPOSE_REQUESTED;

    }
}

