/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.expression.ConnectorExpression;
import java.util.Objects;

public final class JoinCondition {
    private final Operator operator;
    private final ConnectorExpression leftExpression;
    private final ConnectorExpression rightExpression;

    public JoinCondition(Operator operator, ConnectorExpression leftExpression, ConnectorExpression rightExpression) {
        this.operator = Objects.requireNonNull(operator, "operator is null");
        this.leftExpression = Objects.requireNonNull(leftExpression, "leftExpression is null");
        this.rightExpression = Objects.requireNonNull(rightExpression, "rightExpression is null");
    }

    public Operator getOperator() {
        return this.operator;
    }

    public ConnectorExpression getLeftExpression() {
        return this.leftExpression;
    }

    public ConnectorExpression getRightExpression() {
        return this.rightExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinCondition that = (JoinCondition)o;
        return this.operator == that.operator && Objects.equals(this.leftExpression, that.leftExpression) && Objects.equals(this.rightExpression, that.rightExpression);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.leftExpression, this.rightExpression});
    }

    public String toString() {
        return String.format("%s %s %s", this.leftExpression, this.operator.getValue(), this.rightExpression);
    }

    public static enum Operator {
        EQUAL("="),
        NOT_EQUAL("<>"),
        LESS_THAN("<"),
        LESS_THAN_OR_EQUAL("<="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUAL(">="),
        IS_DISTINCT_FROM("IS DISTINCT FROM");

        private final String value;

        private Operator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

