/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * license agreements; and to You under the Apache License, version 2.0:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * This file is part of the Apache Pekko project, which was derived from Akka.
 */

/*
 * Copyright (C) 2016-2022 Lightbend Inc. <https://www.lightbend.com>
 */

package org.apache.pekko.serialization.jackson3;

import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.IntNode;
import tools.jackson.databind.node.ObjectNode;

public class JavaTestEventMigrationV2WithV3 extends JacksonMigration {

  @Override
  public int currentVersion() {
    return 2;
  }

  @Override
  public int supportedForwardVersion() {
    return 3;
  }

  @Override
  public String transformClassName(int fromVersion, String className) {
    // Always produce the type of the currentVersion. When fromVersion is lower,
    // transform will lift it. When fromVersion is higher, transform will downcast it.
    return JavaTestMessages.Event2.class.getName();
  }

  @Override
  public JsonNode transform(int fromVersion, JsonNode json) {
    ObjectNode root = (ObjectNode) json;
    if (fromVersion < 2) {
      root = upcastV1ToV2((ObjectNode) json);
    }
    if (fromVersion == 3) {
      root = downcastV3ToV2((ObjectNode) json);
    }
    return root;
  }

  private ObjectNode upcastV1ToV2(ObjectNode json) {
    ObjectNode root = json;
    root.set("field1V2", root.get("field1"));
    root.remove("field1");
    root.set("field2", IntNode.valueOf(17));
    return root;
  }

  private ObjectNode downcastV3ToV2(ObjectNode json) {
    ObjectNode root = json;
    root.set("field2", root.get("field3"));
    root.remove("field3");
    return root;
  }
}
