/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.util.ThreadUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetriableTask<V>
implements Callable<V> {
    private static final Logger LOG = LoggerFactory.getLogger(RetriableTask.class);
    private final String name;
    private final Callable<V> task;
    private final RetryPolicy retryPolicy;

    public RetriableTask(RetryPolicy retryPolicy, String name, Callable<V> task) {
        this.retryPolicy = retryPolicy;
        this.name = name;
        this.task = task;
    }

    @Override
    public V call() throws Exception {
        int attempts = 0;
        while (true) {
            try {
                return this.task.call();
            }
            catch (Exception e) {
                Exception cause = e;
                RetryPolicy.RetryAction action = this.retryPolicy.shouldRetry(e, ++attempts, 0, true);
                if (action.action == RetryPolicy.RetryAction.RetryDecision.RETRY) {
                    LOG.info("Execution of task {} failed, will be retried in {} ms", (Object)this.name, (Object)action.delayMillis);
                    ThreadUtil.sleepAtLeastIgnoreInterrupts((long)action.delayMillis);
                    continue;
                }
                String msg = String.format("Execution of task %s failed permanently after %d attempts", this.name, attempts);
                LOG.warn(msg, (Throwable)cause);
                throw new IOException(msg, cause);
            }
            break;
        }
    }
}

