/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementPolicyFactory;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementMetrics;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.ECPipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.apache.hadoop.hdds.scm.pipeline.RatisPipelineProvider;
import org.apache.hadoop.hdds.scm.pipeline.SimplePipelineProvider;
import org.apache.hadoop.hdds.server.events.EventPublisher;

public class PipelineFactory {
    private Map<HddsProtos.ReplicationType, PipelineProvider> providers;

    PipelineFactory(NodeManager nodeManager, PipelineStateManager stateManager, ConfigurationSource conf, EventPublisher eventPublisher, SCMContext scmContext) {
        PlacementPolicy ecPlacementPolicy;
        this.providers = new HashMap<HddsProtos.ReplicationType, PipelineProvider>();
        this.providers.put(HddsProtos.ReplicationType.STAND_ALONE, new SimplePipelineProvider(nodeManager, stateManager));
        this.providers.put(HddsProtos.ReplicationType.RATIS, new RatisPipelineProvider(nodeManager, stateManager, conf, eventPublisher, scmContext));
        try {
            ecPlacementPolicy = ContainerPlacementPolicyFactory.getECPolicy(conf, nodeManager, nodeManager.getClusterNetworkTopologyMap(), true, SCMContainerPlacementMetrics.create());
        }
        catch (SCMException e) {
            throw new RuntimeException("Unable to get the container placement policy", e);
        }
        this.providers.put(HddsProtos.ReplicationType.EC, new ECPipelineProvider(nodeManager, stateManager, conf, ecPlacementPolicy));
    }

    protected PipelineFactory() {
    }

    @VisibleForTesting
    void setProvider(HddsProtos.ReplicationType replicationType, PipelineProvider provider) {
        this.providers.put(replicationType, provider);
    }

    public Pipeline create(ReplicationConfig replicationConfig, List<DatanodeDetails> excludedNodes, List<DatanodeDetails> favoredNodes) throws IOException {
        Pipeline pipeline = this.providers.get(replicationConfig.getReplicationType()).create(replicationConfig, excludedNodes, favoredNodes);
        this.checkPipeline(pipeline);
        return pipeline;
    }

    private void checkPipeline(Pipeline pipeline) throws IOException {
        if (pipeline == null) {
            throw new SCMException("Pipeline cannot be null", SCMException.ResultCodes.INTERNAL_ERROR);
        }
        if (pipeline.getNodes().size() != pipeline.getReplicationConfig().getRequiredNodes()) {
            throw new SCMException("Nodes size= " + pipeline.getNodes().size() + ", replication factor= " + pipeline.getReplicationConfig().getRequiredNodes() + " do not match", SCMException.ResultCodes.FAILED_TO_FIND_HEALTHY_NODES);
        }
    }

    public Pipeline create(ReplicationConfig replicationConfig, List<DatanodeDetails> nodes) {
        return this.providers.get(replicationConfig.getReplicationType()).create(replicationConfig, nodes);
    }

    public Pipeline createForRead(ReplicationConfig replicationConfig, Set<ContainerReplica> replicas) {
        return this.providers.get(replicationConfig.getReplicationType()).createForRead(replicationConfig, replicas);
    }

    public void close(HddsProtos.ReplicationType type, Pipeline pipeline) throws IOException {
        this.providers.get(type).close(pipeline);
    }

    public void shutdown() {
        this.providers.values().forEach(provider -> provider.shutdown());
    }

    @VisibleForTesting
    public Map<HddsProtos.ReplicationType, PipelineProvider> getProviders() {
        return this.providers;
    }

    protected void setProviders(Map<HddsProtos.ReplicationType, PipelineProvider> providers) {
        this.providers = providers;
    }
}

