/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha.io;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Proto2Utils;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import org.apache.hadoop.hdds.scm.ha.io.Codec;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;

public class X509CertificateCodec
implements Codec {
    @Override
    public ByteString serialize(Object object) throws InvalidProtocolBufferException {
        try {
            String certString = CertificateCodec.getPEMEncodedString((X509Certificate)((X509Certificate)object));
            return Proto2Utils.unsafeByteString((byte[])certString.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            throw new InvalidProtocolBufferException("X509Certificate cannot be decoded: " + ex.getMessage());
        }
    }

    @Override
    public Object deserialize(Class<?> type, ByteString value) throws InvalidProtocolBufferException {
        try {
            String pemEncodedCert = new String(value.toByteArray(), StandardCharsets.UTF_8);
            return CertificateCodec.getX509Certificate((String)pemEncodedCert);
        }
        catch (Exception ex) {
            throw new InvalidProtocolBufferException("X509Certificate cannot be decoded: " + ex.getMessage());
        }
    }
}

