/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.volume;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.volume.OMQuotaRepairResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.security.UserGroupInformation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMQuotaRepairRequest
extends OMClientRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMQuotaRepairRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMQuotaRepairRequest.class);
    }

    public OMQuotaRepairRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        UserGroupInformation ugi = this.createUGIForApi();
        if (ozoneManager.getAclsEnabled() && !ozoneManager.isAdmin(ugi)) {
            throw new OMException("Access denied for user " + ugi + ". Admin privilege is required for quota repair.", OMException.ResultCodes.ACCESS_DENIED);
        }
        return super.preExecute(ozoneManager);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        long transactionLogIndex = context.getIndex();
        OzoneManagerProtocolProtos.QuotaRepairRequest quotaRepairRequest = this.getOmRequest().getQuotaRepairRequest();
        Preconditions.checkNotNull((Object)quotaRepairRequest);
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
        HashMap<Pair<String, String>, OmBucketInfo> bucketMap = new HashMap<Pair<String, String>, OmBucketInfo>();
        OMClientResponse omClientResponse = null;
        try {
            try {
                int i = 0;
                while (i < quotaRepairRequest.getBucketCountCount()) {
                    OzoneManagerProtocolProtos.BucketQuotaCount bucketCountInfo = quotaRepairRequest.getBucketCount(i);
                    this.updateBucketInfo(omMetadataManager, bucketCountInfo, transactionLogIndex, bucketMap);
                    ++i;
                }
                Map<Object, Object> volUpdateMap = quotaRepairRequest.getSupportVolumeOldQuota() ? this.updateOldVolumeQuotaSupport(omMetadataManager, transactionLogIndex) : Collections.emptyMap();
                omResponse.setQuotaRepairResponse(OzoneManagerProtocolProtos.QuotaRepairResponse.newBuilder().build());
                omClientResponse = new OMQuotaRepairResponse(omResponse.build(), volUpdateMap, bucketMap);
            }
            catch (IOException ex) {
                LOG.error("failed to update repair count", (Throwable)ex);
                omClientResponse = new OMQuotaRepairResponse(this.createErrorOMResponse(omResponse, ex));
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
            }
        }
        finally {
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        return omClientResponse;
    }

    private void updateBucketInfo(OMMetadataManager omMetadataManager, OzoneManagerProtocolProtos.BucketQuotaCount bucketCountInfo, long transactionLogIndex, Map<Pair<String, String>, OmBucketInfo> bucketMap) throws IOException {
        OmBucketInfo bucketInfo;
        String bucketKey;
        boolean acquiredBucketLock;
        block8: {
            block9: {
                this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{bucketCountInfo.getVolName(), bucketCountInfo.getBucketName()}));
                acquiredBucketLock = this.getOmLockDetails().isLockAcquired();
                try {
                    bucketKey = omMetadataManager.getBucketKey(bucketCountInfo.getVolName(), bucketCountInfo.getBucketName());
                    bucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey);
                    if (bucketInfo != null) break block8;
                    if (!acquiredBucketLock) break block9;
                }
                catch (Throwable throwable) {
                    if (acquiredBucketLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{bucketCountInfo.getVolName(), bucketCountInfo.getBucketName()}));
                    }
                    throw throwable;
                }
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{bucketCountInfo.getVolName(), bucketCountInfo.getBucketName()}));
            }
            return;
        }
        bucketInfo.incrUsedBytes(bucketCountInfo.getDiffUsedBytes());
        bucketInfo.incrUsedNamespace(bucketCountInfo.getDiffUsedNamespace());
        if (bucketCountInfo.getSupportOldQuota()) {
            OmBucketInfo.Builder builder = bucketInfo.toBuilder();
            if (bucketInfo.getQuotaInBytes() == -2L) {
                builder.setQuotaInBytes(-1L);
            }
            if (bucketInfo.getQuotaInNamespace() == -2L) {
                builder.setQuotaInNamespace(-1L);
            }
            bucketInfo = builder.build();
        }
        omMetadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)bucketKey), CacheValue.get((long)transactionLogIndex, (Object)bucketInfo));
        bucketMap.put((Pair<String, String>)Pair.of((Object)bucketCountInfo.getVolName(), (Object)bucketCountInfo.getBucketName()), bucketInfo);
        if (acquiredBucketLock) {
            this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.BUCKET_LOCK, new String[]{bucketCountInfo.getVolName(), bucketCountInfo.getBucketName()}));
        }
    }

    private Map<String, OmVolumeArgs> updateOldVolumeQuotaSupport(OMMetadataManager metadataManager, long transactionLogIndex) throws IOException {
        LOG.info("Starting volume quota support update");
        HashMap<String, OmVolumeArgs> volUpdateMap = new HashMap<String, OmVolumeArgs>();
        Throwable throwable = null;
        Object var6_6 = null;
        try (Table.KeyValueIterator iterator = metadataManager.getVolumeTable().iterator();){
            while (iterator.hasNext()) {
                Table.KeyValue entry = (Table.KeyValue)iterator.next();
                OmVolumeArgs omVolumeArgs = (OmVolumeArgs)entry.getValue();
                if (omVolumeArgs.getQuotaInBytes() != -2L && omVolumeArgs.getQuotaInNamespace() != -2L) continue;
                this.mergeOmLockDetails(metadataManager.getLock().acquireWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{omVolumeArgs.getVolume()}));
                boolean acquiredVolumeLock = this.getOmLockDetails().isLockAcquired();
                try {
                    boolean isQuotaReset = false;
                    if (omVolumeArgs.getQuotaInBytes() == -2L) {
                        omVolumeArgs.setQuotaInBytes(-1L);
                        isQuotaReset = true;
                    }
                    if (omVolumeArgs.getQuotaInNamespace() == -2L) {
                        omVolumeArgs.setQuotaInNamespace(-1L);
                        isQuotaReset = true;
                    }
                    if (isQuotaReset) {
                        metadataManager.getVolumeTable().addCacheEntry(new CacheKey((Object)((String)entry.getKey())), CacheValue.get((long)transactionLogIndex, (Object)omVolumeArgs));
                        volUpdateMap.put((String)entry.getKey(), omVolumeArgs);
                    }
                }
                catch (Throwable throwable2) {
                    if (acquiredVolumeLock) {
                        this.mergeOmLockDetails(metadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{omVolumeArgs.getVolume()}));
                    }
                    throw throwable2;
                }
                if (!acquiredVolumeLock) continue;
                this.mergeOmLockDetails(metadataManager.getLock().releaseWriteLock((IOzoneManagerLock.Resource)OzoneManagerLock.LeveledResource.VOLUME_LOCK, new String[]{omVolumeArgs.getVolume()}));
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        LOG.info("Completed volume quota support update for volume count {}", (Object)volUpdateMap.size());
        return volUpdateMap;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMQuotaRepairRequest.java", OMQuotaRepairRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.volume.OMQuotaRepairRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 63);
    }
}

