/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.hadoop.ozone.om.OmSnapshotLocalData;
import org.apache.ozone.compaction.log.SstFileInfo;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

public final class OmSnapshotLocalDataYaml {
    public static final Tag SNAPSHOT_YAML_TAG = new Tag("OmSnapshotLocalData");
    public static final Tag SNAPSHOT_VERSION_META_TAG = new Tag("VersionMeta");
    public static final Tag SST_FILE_INFO_TAG = new Tag("SstFileInfo");
    public static final String YAML_FILE_EXTENSION = ".yaml";

    private OmSnapshotLocalDataYaml() {
    }

    private static class OmSnapshotLocalDataRepresenter
    extends Representer {
        OmSnapshotLocalDataRepresenter(DumperOptions options) {
            super(options);
            this.addClassTag(OmSnapshotLocalData.class, SNAPSHOT_YAML_TAG);
            this.addClassTag(OmSnapshotLocalData.VersionMeta.class, SNAPSHOT_VERSION_META_TAG);
            this.addClassTag(SstFileInfo.class, SST_FILE_INFO_TAG);
            this.representers.put(SstFileInfo.class, new RepresentSstFileInfo());
            this.representers.put(OmSnapshotLocalData.VersionMeta.class, new RepresentVersionMeta());
            this.representers.put(UUID.class, data -> new ScalarNode(Tag.STR, data.toString(), null, null, DumperOptions.ScalarStyle.PLAIN));
        }

        protected NodeTuple representJavaBeanProperty(Object bean, Property property, Object value, Tag tag) {
            return value == null ? null : super.representJavaBeanProperty(bean, property, value, tag);
        }

        private class RepresentSstFileInfo
        implements Represent {
            private RepresentSstFileInfo() {
            }

            public Node representData(Object data) {
                SstFileInfo info = (SstFileInfo)data;
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("fileName", info.getFileName());
                map.put("startKey", info.getStartKey());
                map.put("endKey", info.getEndKey());
                map.put("columnFamily", info.getColumnFamily());
                return OmSnapshotLocalDataRepresenter.this.representMapping(SST_FILE_INFO_TAG, map, DumperOptions.FlowStyle.BLOCK);
            }
        }

        private class RepresentVersionMeta
        implements Represent {
            private RepresentVersionMeta() {
            }

            public Node representData(Object data) {
                OmSnapshotLocalData.VersionMeta meta = (OmSnapshotLocalData.VersionMeta)data;
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("previousSnapshotVersion", meta.getPreviousSnapshotVersion());
                map.put("sstFiles", meta.getSstFiles());
                return OmSnapshotLocalDataRepresenter.this.representMapping(SNAPSHOT_VERSION_META_TAG, map, DumperOptions.FlowStyle.BLOCK);
            }
        }
    }

    private static class SnapshotLocalDataConstructor
    extends SafeConstructor {
        SnapshotLocalDataConstructor() {
            super(new LoaderOptions());
            this.yamlConstructors.put(SNAPSHOT_YAML_TAG, new ConstructSnapshotLocalData());
            this.yamlConstructors.put(SNAPSHOT_VERSION_META_TAG, new ConstructVersionMeta());
            this.yamlConstructors.put(SST_FILE_INFO_TAG, new ConstructSstFileInfo());
            TypeDescription omDesc = new TypeDescription(OmSnapshotLocalData.class);
            omDesc.putMapPropertyType("versionSstFileInfos", Integer.class, OmSnapshotLocalData.VersionMeta.class);
            this.addTypeDescription(omDesc);
            TypeDescription versionMetaDesc = new TypeDescription(OmSnapshotLocalData.VersionMeta.class);
            versionMetaDesc.putListPropertyType("sstFiles", SstFileInfo.class);
            this.addTypeDescription(versionMetaDesc);
        }

        private final class ConstructSnapshotLocalData
        extends AbstractConstruct {
            private ConstructSnapshotLocalData() {
            }

            public Object construct(Node node) {
                String checksum;
                MappingNode mnode = (MappingNode)node;
                Map nodes = SnapshotLocalDataConstructor.this.constructMapping(mnode);
                String snapIdStr = (String)nodes.get("snapshotId");
                UUID snapId = UUID.fromString(snapIdStr);
                String prevSnapIdStr = (String)nodes.get("previousSnapshotId");
                UUID prevSnapId = prevSnapIdStr != null ? UUID.fromString(prevSnapIdStr) : null;
                OmSnapshotLocalData snapshotLocalData = new OmSnapshotLocalData(snapId, Collections.emptyList(), prevSnapId);
                Integer version = (Integer)nodes.get("version");
                snapshotLocalData.setVersion(version);
                snapshotLocalData.setSstFiltered(nodes.getOrDefault("isSSTFiltered", false));
                Long lastDefragTimeObj = nodes.getOrDefault("lastDefragTime", -1L);
                if (!(lastDefragTimeObj instanceof Number)) {
                    throw new IllegalArgumentException("Invalid type for lastDefragTime: " + lastDefragTimeObj.getClass().getName() + ". Expected Number type.");
                }
                long lastDefragTime = ((Number)lastDefragTimeObj).longValue();
                snapshotLocalData.setLastDefragTime(lastDefragTime);
                snapshotLocalData.setNeedsDefrag(nodes.getOrDefault("needsDefrag", false));
                Map versionMetaMap = (Map)nodes.get("versionSstFileInfos");
                if (versionMetaMap != null) {
                    snapshotLocalData.setVersionSstFileInfos(versionMetaMap);
                }
                if ((checksum = (String)nodes.get("checksum")) != null) {
                    snapshotLocalData.setChecksum(checksum);
                }
                return snapshotLocalData;
            }
        }

        private final class ConstructSstFileInfo
        extends AbstractConstruct {
            private ConstructSstFileInfo() {
            }

            public Object construct(Node node) {
                MappingNode mnode = (MappingNode)node;
                Map nodes = SnapshotLocalDataConstructor.this.constructMapping(mnode);
                return new SstFileInfo((String)nodes.get("fileName"), (String)nodes.get("startKey"), (String)nodes.get("endKey"), (String)nodes.get("columnFamily"));
            }
        }

        private final class ConstructVersionMeta
        extends AbstractConstruct {
            private ConstructVersionMeta() {
            }

            public Object construct(Node node) {
                MappingNode mnode = (MappingNode)node;
                Map nodes = SnapshotLocalDataConstructor.this.constructMapping(mnode);
                return new OmSnapshotLocalData.VersionMeta((Integer)nodes.get("previousSnapshotVersion"), (List)nodes.get("sstFiles"));
            }
        }
    }

    public static class YamlFactory
    extends BasePooledObjectFactory<Yaml> {
        public Yaml create() {
            PropertyUtils propertyUtils = new PropertyUtils();
            propertyUtils.setBeanAccess(BeanAccess.FIELD);
            propertyUtils.setAllowReadOnlyProperties(true);
            DumperOptions options = new DumperOptions();
            OmSnapshotLocalDataRepresenter representer = new OmSnapshotLocalDataRepresenter(options);
            representer.setPropertyUtils(propertyUtils);
            SnapshotLocalDataConstructor snapshotDataConstructor = new SnapshotLocalDataConstructor();
            return new Yaml((BaseConstructor)snapshotDataConstructor, (Representer)representer);
        }

        public PooledObject<Yaml> wrap(Yaml yaml) {
            return new DefaultPooledObject((Object)yaml);
        }
    }
}

