/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.utils;

import java.io.File;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.orc.Writer;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.audit.utils.AbstractRangerAuditWriter;
import org.apache.ranger.audit.utils.ORCFileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerORCAuditWriter
extends AbstractRangerAuditWriter {
    private static final Logger logger = LoggerFactory.getLogger(RangerORCAuditWriter.class);
    protected static final String ORC_FILE_EXTENSION = ".orc";
    protected volatile ORCFileUtil orcFileUtil = null;
    protected Writer orcLogWriter = null;
    protected String fileType = "orc";
    protected String compression = null;
    protected int orcBufferSize = 0;
    protected int defaultbufferSize = 100000;
    protected long orcStripeSize = 0L;
    protected long defaultStripeSize = 100000L;

    @Override
    public void init(Properties props, String propPrefix, String auditProviderName, Map<String, String> auditConfigs) {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerORCAuditWriter.init()");
        }
        this.init(props, propPrefix, auditProviderName);
        super.init(props, propPrefix, auditProviderName, auditConfigs);
        if (logger.isDebugEnabled()) {
            logger.debug("<== RangerORCAuditWriter.init()");
        }
    }

    public synchronized boolean logAuditAsORC(final Collection<AuthzAuditEvent> events) throws Exception {
        boolean ret = false;
        Writer out = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("UGI=" + MiscUtil.getUGILoginUser() + ". Will write to HDFS file=" + this.currentFileName);
            }
            out = MiscUtil.executePrivilegedAction(new PrivilegedExceptionAction<Writer>(){

                @Override
                public Writer run() throws Exception {
                    Writer out = RangerORCAuditWriter.this.getORCFileWrite();
                    RangerORCAuditWriter.this.orcFileUtil.log(out, events);
                    return out;
                }
            });
        }
        catch (Exception e) {
            this.orcLogWriter = null;
            logger.error("Error while writing into ORC FileWriter", (Throwable)e);
            throw e;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug("Flushing HDFS audit in ORC Format. Event Size:" + events.size());
            }
            if (out != null) {
                try {
                    this.orcFileUtil.close(out);
                    ret = true;
                }
                catch (Exception e) {
                    logger.error("Error while closing the ORC FileWriter", (Throwable)e);
                    throw e;
                }
                this.orcLogWriter = null;
            }
        }
        return ret;
    }

    @Override
    public void flush() {
    }

    @Override
    public boolean log(Collection<String> events) throws Exception {
        return this.logAsORC(events);
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized void stop() {
        if (this.orcLogWriter != null) {
            try {
                this.orcFileUtil.close(this.orcLogWriter);
            }
            catch (Throwable t) {
                logger.error("Error on closing log ORC Writer. Exception will be ignored. name=" + this.auditProviderName + ", fileName=" + this.currentFileName);
            }
            this.orcLogWriter = null;
        }
    }

    @Override
    public boolean logFile(File file) throws Exception {
        return false;
    }

    protected synchronized Writer getORCFileWrite() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("==> RangerORCAuditWriter.getORCFileWrite()");
        }
        if (this.orcLogWriter == null) {
            this.createFileSystemFolders();
            logger.info("Creating new log file. hdfPath=" + this.fullPath);
            this.orcLogWriter = this.orcFileUtil.createWriter(this.conf, this.fileSystem, this.fullPath);
            this.currentFileName = this.fullPath;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== RangerORCAuditWriter.getORCFileWrite()");
        }
        return this.orcLogWriter;
    }

    public boolean logAsORC(Collection<String> events) throws Exception {
        boolean ret = false;
        Collection<AuthzAuditEvent> authzAuditEvents = this.getAuthzAuditEvents(events);
        ret = this.logAuditAsORC(authzAuditEvents);
        return ret;
    }

    public Collection<AuthzAuditEvent> getAuthzAuditEvents(Collection<String> events) throws Exception {
        ArrayList<AuthzAuditEvent> ret = new ArrayList<AuthzAuditEvent>();
        for (String event : events) {
            try {
                AuthzAuditEvent authzAuditEvent = MiscUtil.fromJson(event, AuthzAuditEvent.class);
                ret.add(authzAuditEvent);
            }
            catch (Exception e) {
                logger.error("Error converting to From JSON to AuthzAuditEvent=" + event);
                throw e;
            }
        }
        return ret;
    }

    public void init(Properties props, String propPrefix, String auditProviderName) {
        this.compression = MiscUtil.getStringProperty(props, propPrefix + "." + this.fileType + ".compression");
        this.orcBufferSize = MiscUtil.getIntProperty(props, propPrefix + "." + this.fileType + ".buffersize", this.defaultbufferSize);
        this.orcStripeSize = MiscUtil.getLongProperty(props, propPrefix + "." + this.fileType + ".stripesize", this.defaultStripeSize);
        this.setFileExtension(ORC_FILE_EXTENSION);
        try {
            this.orcFileUtil = ORCFileUtil.getInstance();
            this.orcFileUtil.init(this.orcBufferSize, this.orcStripeSize, this.compression);
        }
        catch (Exception e) {
            logger.error("Error while doing ORCWriter.init() ", (Throwable)e);
        }
    }
}

