/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.rocksdb.util;

import jakarta.annotation.Nonnull;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.db.managed.ManagedOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRawSSTFileIterator;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRawSSTFileReader;
import org.apache.hadoop.hdds.utils.db.managed.ManagedReadOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedSlice;
import org.apache.hadoop.hdds.utils.db.managed.ManagedSstFileReader;
import org.apache.hadoop.hdds.utils.db.managed.ManagedSstFileReaderIterator;
import org.apache.hadoop.ozone.util.ClosableIterator;
import org.rocksdb.AbstractSlice;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.SstFileReaderIterator;

public class SstFileSetReader {
    private final Collection<String> sstFiles;
    private volatile long estimatedTotalKeys = -1L;

    public SstFileSetReader(Collection<String> sstFiles) {
        this.sstFiles = sstFiles;
    }

    public static <T> Stream<T> getStreamFromIterator(ClosableIterator<T> itr) {
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(itr, 0);
        return (Stream)StreamSupport.stream(spliterator, false).onClose(() -> itr.close());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEstimatedTotalKeys() throws RocksDBException {
        if (this.estimatedTotalKeys != -1L) {
            return this.estimatedTotalKeys;
        }
        long estimatedSize = 0L;
        SstFileSetReader sstFileSetReader = this;
        synchronized (sstFileSetReader) {
            if (this.estimatedTotalKeys != -1L) {
                return this.estimatedTotalKeys;
            }
            try (ManagedOptions options = new ManagedOptions();){
                for (String sstFile : this.sstFiles) {
                    try (ManagedSstFileReader fileReader = new ManagedSstFileReader((Options)options);){
                        fileReader.open(sstFile);
                        estimatedSize += fileReader.getTableProperties().getNumEntries();
                    }
                }
            }
            this.estimatedTotalKeys = estimatedSize;
        }
        return this.estimatedTotalKeys;
    }

    public Stream<String> getKeyStream(final String lowerBound, final String upperBound) throws RocksDBException {
        MultipleSstFileIterator<String> itr = new MultipleSstFileIterator<String>(this.sstFiles){
            private ManagedOptions options;
            private ManagedReadOptions readOptions;
            private ManagedSlice lowerBoundSLice;
            private ManagedSlice upperBoundSlice;

            @Override
            protected void init() {
                this.options = new ManagedOptions();
                this.readOptions = new ManagedReadOptions();
                if (Objects.nonNull(lowerBound)) {
                    this.lowerBoundSLice = new ManagedSlice(StringUtils.string2Bytes((String)lowerBound));
                    this.readOptions.setIterateLowerBound((AbstractSlice)this.lowerBoundSLice);
                }
                if (Objects.nonNull(upperBound)) {
                    this.upperBoundSlice = new ManagedSlice(StringUtils.string2Bytes((String)upperBound));
                    this.readOptions.setIterateUpperBound((AbstractSlice)this.upperBoundSlice);
                }
            }

            @Override
            protected ClosableIterator<String> getKeyIteratorForFile(String file) throws RocksDBException {
                return new ManagedSstFileIterator(file, this.options, this.readOptions){

                    @Override
                    protected String getIteratorValue(ManagedSstFileReaderIterator iterator) {
                        return new String(((SstFileReaderIterator)iterator.get()).key(), StandardCharsets.UTF_8);
                    }
                };
            }

            @Override
            public void close() throws UncheckedIOException {
                super.close();
                this.options.close();
                this.readOptions.close();
                IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.lowerBoundSLice, this.upperBoundSlice});
            }
        };
        return SstFileSetReader.getStreamFromIterator(itr);
    }

    public Stream<String> getKeyStreamWithTombstone(final String lowerBound, final String upperBound) throws RocksDBException {
        MultipleSstFileIterator<String> itr = new MultipleSstFileIterator<String>(this.sstFiles){
            private ManagedOptions options;
            private ManagedSlice lowerBoundSlice;
            private ManagedSlice upperBoundSlice;

            @Override
            protected void init() {
                this.options = new ManagedOptions();
                if (Objects.nonNull(lowerBound)) {
                    this.lowerBoundSlice = new ManagedSlice(StringUtils.string2Bytes((String)lowerBound));
                }
                if (Objects.nonNull(upperBound)) {
                    this.upperBoundSlice = new ManagedSlice(StringUtils.string2Bytes((String)upperBound));
                }
            }

            @Override
            protected ClosableIterator<String> getKeyIteratorForFile(String file) {
                return new ManagedRawSstFileIterator(file, this.options, this.lowerBoundSlice, this.upperBoundSlice, keyValue -> StringUtils.bytes2String((byte[])keyValue.getKey()));
            }

            @Override
            public void close() throws UncheckedIOException {
                super.close();
                this.options.close();
                IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.lowerBoundSlice, this.upperBoundSlice});
            }
        };
        return SstFileSetReader.getStreamFromIterator(itr);
    }

    private static abstract class MultipleSstFileIterator<T extends Comparable<T>>
    implements ClosableIterator<T> {
        private final PriorityQueue<HeapEntry<T>> minHeap = new PriorityQueue();

        private MultipleSstFileIterator(Collection<String> sstFiles) {
            this.init();
            this.initMinHeap(sstFiles);
        }

        protected abstract void init();

        protected abstract ClosableIterator<T> getKeyIteratorForFile(String var1) throws RocksDBException, IOException;

        private void initMinHeap(Collection<String> files) {
            try {
                for (String file : files) {
                    ClosableIterator<T> iterator = this.getKeyIteratorForFile(file);
                    HeapEntry<T> entry = new HeapEntry<T>(iterator);
                    if (entry.getCurrentKey() != null) {
                        this.minHeap.offer(entry);
                        continue;
                    }
                    entry.close();
                }
            }
            catch (IOException | RocksDBException e) {
                this.close();
                throw new RuntimeException("Failed to initialize SST file iterators", e);
            }
        }

        public boolean hasNext() {
            return !this.minHeap.isEmpty();
        }

        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements found.");
            }
            assert (this.minHeap.peek() != null);
            T currentKey = this.minHeap.peek().getCurrentKey();
            while (!this.minHeap.isEmpty() && Objects.equals(this.minHeap.peek().getCurrentKey(), currentKey)) {
                HeapEntry<T> entry = this.minHeap.poll();
                if (entry.advance()) {
                    this.minHeap.offer(entry);
                    continue;
                }
                entry.close();
            }
            return currentKey;
        }

        public void close() {
            while (!this.minHeap.isEmpty()) {
                this.minHeap.poll().close();
            }
        }
    }

    private static class HeapEntry<T extends Comparable<T>>
    implements Comparable<HeapEntry<T>>,
    Closeable {
        private final ClosableIterator<T> iterator;
        private T currentKey;

        HeapEntry(ClosableIterator<T> iterator) {
            this.iterator = iterator;
            this.advance();
        }

        @Override
        public void close() {
            this.iterator.close();
        }

        boolean advance() {
            if (this.iterator.hasNext()) {
                this.currentKey = (Comparable)this.iterator.next();
                return true;
            }
            this.currentKey = null;
            return false;
        }

        T getCurrentKey() {
            return this.currentKey;
        }

        @Override
        public int compareTo(@Nonnull HeapEntry<T> other) {
            return Comparator.comparing(HeapEntry::getCurrentKey).compare(this, other);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            HeapEntry other = (HeapEntry)obj;
            return this.compareTo(other) == 0;
        }

        public int hashCode() {
            return this.currentKey.hashCode();
        }
    }

    private static class ManagedRawSstFileIterator
    implements ClosableIterator<String> {
        private final ManagedRawSSTFileReader<String> fileReader;
        private final ManagedRawSSTFileIterator<String> fileReaderIterator;
        private static final int READ_AHEAD_SIZE = 0x200000;

        ManagedRawSstFileIterator(String path, ManagedOptions options, ManagedSlice lowerBound, ManagedSlice upperBound, Function<ManagedRawSSTFileIterator.KeyValue, String> keyValueFunction) {
            this.fileReader = new ManagedRawSSTFileReader(options, path, 0x200000);
            this.fileReaderIterator = this.fileReader.newIterator(keyValueFunction, lowerBound, upperBound);
        }

        public void close() {
            this.fileReaderIterator.close();
            this.fileReader.close();
        }

        public boolean hasNext() {
            return this.fileReaderIterator.hasNext();
        }

        public String next() {
            return (String)this.fileReaderIterator.next();
        }
    }

    private static abstract class ManagedSstFileIterator
    implements ClosableIterator<String> {
        private final ManagedSstFileReader fileReader;
        private final ManagedSstFileReaderIterator fileReaderIterator;

        ManagedSstFileIterator(String path, ManagedOptions options, ManagedReadOptions readOptions) throws RocksDBException {
            this.fileReader = new ManagedSstFileReader((Options)options);
            this.fileReader.open(path);
            this.fileReaderIterator = ManagedSstFileReaderIterator.managed((SstFileReaderIterator)this.fileReader.newIterator((ReadOptions)readOptions));
            ((SstFileReaderIterator)this.fileReaderIterator.get()).seekToFirst();
        }

        public void close() {
            this.fileReaderIterator.close();
            this.fileReader.close();
        }

        public boolean hasNext() {
            return ((SstFileReaderIterator)this.fileReaderIterator.get()).isValid();
        }

        protected abstract String getIteratorValue(ManagedSstFileReaderIterator var1);

        public String next() {
            String value = this.getIteratorValue(this.fileReaderIterator);
            ((SstFileReaderIterator)this.fileReaderIterator.get()).next();
            return value;
        }
    }
}

