/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;
import org.apache.hadoop.ozone.recon.tasks.NSSummaryTaskDbEventHandler;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdateEvent;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSummaryTaskWithOBS
extends NSSummaryTaskDbEventHandler {
    private static final BucketLayout BUCKET_LAYOUT = BucketLayout.OBJECT_STORE;
    private static final Logger LOG = LoggerFactory.getLogger(NSSummaryTaskWithOBS.class);
    private final long nsSummaryFlushToDBMaxThreshold;

    public NSSummaryTaskWithOBS(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager reconOMMetadataManager, long nsSummaryFlushToDBMaxThreshold) {
        super(reconNamespaceSummaryManager, reconOMMetadataManager);
        this.nsSummaryFlushToDBMaxThreshold = nsSummaryFlushToDBMaxThreshold;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reprocessWithOBS(OMMetadataManager omMetadataManager) {
        HashMap<Long, NSSummary> nsSummaryMap = new HashMap<Long, NSSummary>();
        try {
            Table keyTable = omMetadataManager.getKeyTable(BUCKET_LAYOUT);
            try (Table.KeyValueIterator keyTableIter = keyTable.iterator();){
                while (keyTableIter.hasNext()) {
                    Table.KeyValue kv = (Table.KeyValue)keyTableIter.next();
                    OmKeyInfo keyInfo = (OmKeyInfo)kv.getValue();
                    String volumeName = keyInfo.getVolumeName();
                    String bucketName = keyInfo.getBucketName();
                    String bucketDBKey = omMetadataManager.getBucketKey(volumeName, bucketName);
                    OmBucketInfo omBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().getSkipCache((Object)bucketDBKey);
                    if (omBucketInfo.getBucketLayout() != BUCKET_LAYOUT) continue;
                    this.setKeyParentID(keyInfo);
                    this.handlePutKeyEvent(keyInfo, nsSummaryMap);
                    if ((long)nsSummaryMap.size() < this.nsSummaryFlushToDBMaxThreshold || this.flushAndCommitNSToDB(nsSummaryMap)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (IOException ioEx) {
            LOG.error("Unable to reprocess Namespace Summary data in Recon DB. ", (Throwable)ioEx);
            nsSummaryMap.clear();
            return false;
        }
        if (!this.flushAndCommitNSToDB(nsSummaryMap)) {
            return false;
        }
        LOG.debug("Completed a reprocess run of NSSummaryTaskWithOBS");
        return true;
    }

    public Pair<Integer, Boolean> processWithOBS(OMUpdateEventBatch events, int seekPos) {
        Iterator<OMDBUpdateEvent> eventIterator = events.getIterator();
        HashMap<Long, NSSummary> nsSummaryMap = new HashMap<Long, NSSummary>();
        for (int itrPos = 0; eventIterator.hasNext() && itrPos < seekPos; ++itrPos) {
            eventIterator.next();
        }
        int eventCounter = 0;
        while (eventIterator.hasNext()) {
            OMDBUpdateEvent omdbUpdateEvent = eventIterator.next();
            OMDBUpdateEvent.OMDBUpdateAction action = omdbUpdateEvent.getAction();
            ++eventCounter;
            String table = omdbUpdateEvent.getTable();
            boolean updateOnKeyTable = table.equals("keyTable");
            if (!updateOnKeyTable) continue;
            String updatedKey = (String)omdbUpdateEvent.getKey();
            try {
                OMDBUpdateEvent keyTableUpdateEvent = omdbUpdateEvent;
                Object value = keyTableUpdateEvent.getValue();
                Object oldValue = keyTableUpdateEvent.getOldValue();
                if (value == null) {
                    LOG.warn("Value is null for key {}. Skipping processing.", (Object)updatedKey);
                    continue;
                }
                if (!(value instanceof OmKeyInfo)) {
                    LOG.warn("Unexpected value type {} for key {}. Skipping processing.", (Object)value.getClass().getName(), (Object)updatedKey);
                    continue;
                }
                OmKeyInfo updatedKeyInfo = (OmKeyInfo)value;
                OmKeyInfo oldKeyInfo = (OmKeyInfo)oldValue;
                String volumeName = updatedKeyInfo.getVolumeName();
                String bucketName = updatedKeyInfo.getBucketName();
                String bucketDBKey = this.getReconOMMetadataManager().getBucketKey(volumeName, bucketName);
                OmBucketInfo omBucketInfo = (OmBucketInfo)this.getReconOMMetadataManager().getBucketTable().getSkipCache((Object)bucketDBKey);
                if (omBucketInfo.getBucketLayout() != BUCKET_LAYOUT) continue;
                this.setKeyParentID(updatedKeyInfo);
                switch (action) {
                    case PUT: {
                        this.handlePutKeyEvent(updatedKeyInfo, nsSummaryMap);
                        break;
                    }
                    case DELETE: {
                        this.handleDeleteKeyEvent(updatedKeyInfo, nsSummaryMap);
                        break;
                    }
                    case UPDATE: {
                        if (oldKeyInfo != null) {
                            this.setKeyParentID(oldKeyInfo);
                            this.handleDeleteKeyEvent(oldKeyInfo, nsSummaryMap);
                        } else {
                            LOG.warn("Update event does not have the old keyInfo for {}.", (Object)updatedKey);
                        }
                        this.handlePutKeyEvent(updatedKeyInfo, nsSummaryMap);
                        break;
                    }
                    default: {
                        LOG.debug("Skipping DB update event: {}", (Object)action);
                    }
                }
                if ((long)nsSummaryMap.size() < this.nsSummaryFlushToDBMaxThreshold) continue;
                if (!this.flushAndCommitNSToDB(nsSummaryMap)) {
                    return new ImmutablePair((Object)seekPos, (Object)false);
                }
                seekPos = eventCounter + 1;
            }
            catch (IOException ioEx) {
                LOG.error("Unable to process Namespace Summary data in Recon DB. ", (Throwable)ioEx);
                nsSummaryMap.clear();
                return new ImmutablePair((Object)seekPos, (Object)false);
            }
        }
        if (!this.flushAndCommitNSToDB(nsSummaryMap)) {
            return new ImmutablePair((Object)seekPos, (Object)false);
        }
        LOG.debug("Completed a process run of NSSummaryTaskWithOBS");
        return new ImmutablePair((Object)seekPos, (Object)true);
    }

    private void setKeyParentID(OmKeyInfo keyInfo) throws IOException {
        String bucketKey = this.getReconOMMetadataManager().getBucketKey(keyInfo.getVolumeName(), keyInfo.getBucketName());
        OmBucketInfo parentBucketInfo = (OmBucketInfo)this.getReconOMMetadataManager().getBucketTable().getSkipCache((Object)bucketKey);
        if (parentBucketInfo == null) {
            LOG.warn("ParentBucketInfo is null for key: %s in volume: %s, bucket: %s", new Object[]{keyInfo.getKeyName(), keyInfo.getVolumeName(), keyInfo.getBucketName()});
            throw new IOException("ParentKeyInfo for NSSummaryTaskWithOBS is null");
        }
        keyInfo.setParentObjectID(parentBucketInfo.getObjectID());
    }
}

