/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.handlers;

import java.io.IOException;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.recon.api.handlers.BucketHandler;
import org.apache.hadoop.ozone.recon.api.handlers.EntityHandler;
import org.apache.hadoop.ozone.recon.api.types.CountStats;
import org.apache.hadoop.ozone.recon.api.types.DUResponse;
import org.apache.hadoop.ozone.recon.api.types.EntityType;
import org.apache.hadoop.ozone.recon.api.types.FileSizeDistributionResponse;
import org.apache.hadoop.ozone.recon.api.types.KeyObjectDBInfo;
import org.apache.hadoop.ozone.recon.api.types.NamespaceSummaryResponse;
import org.apache.hadoop.ozone.recon.api.types.ObjectDBInfo;
import org.apache.hadoop.ozone.recon.api.types.QuotaUsageResponse;
import org.apache.hadoop.ozone.recon.api.types.ResponseStatus;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;

public class KeyEntityHandler
extends EntityHandler {
    public KeyEntityHandler(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM, BucketHandler bucketHandler, String path) {
        super(reconNamespaceSummaryManager, omMetadataManager, reconSCM, bucketHandler, path);
    }

    @Override
    public NamespaceSummaryResponse getSummaryResponse() throws IOException {
        CountStats countStats = new CountStats(-1, -1, -1, 0L);
        return NamespaceSummaryResponse.newBuilder().setEntityType(EntityType.KEY).setCountStats(countStats).setObjectDBInfo(this.getKeyDbObjectInfo(this.getNames())).setStatus(ResponseStatus.OK).build();
    }

    private ObjectDBInfo getKeyDbObjectInfo(String[] names) throws IOException {
        OmKeyInfo omKeyInfo = this.getBucketHandler().getKeyInfo(names);
        if (null == omKeyInfo) {
            return new KeyObjectDBInfo();
        }
        return new KeyObjectDBInfo(omKeyInfo);
    }

    @Override
    public DUResponse getDuResponse(boolean listFile, boolean withReplica, boolean sort) throws IOException {
        DUResponse duResponse = new DUResponse();
        duResponse.setPath(this.getNormalizedPath());
        duResponse.setCount(0);
        OmKeyInfo keyInfo = this.getBucketHandler().getKeyInfo(this.getNames());
        duResponse.setSize(keyInfo.getDataSize());
        if (withReplica) {
            long keySizeWithReplica = keyInfo.getReplicatedSize();
            duResponse.setSizeWithReplica(keySizeWithReplica);
        }
        return duResponse;
    }

    @Override
    public QuotaUsageResponse getQuotaResponse() throws IOException {
        QuotaUsageResponse quotaUsageResponse = new QuotaUsageResponse();
        quotaUsageResponse.setResponseCode(ResponseStatus.TYPE_NOT_APPLICABLE);
        return quotaUsageResponse;
    }

    @Override
    public FileSizeDistributionResponse getDistResponse() throws IOException {
        FileSizeDistributionResponse distResponse = new FileSizeDistributionResponse();
        distResponse.setStatus(ResponseStatus.TYPE_NOT_APPLICABLE);
        return distResponse;
    }
}

