/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.api.handlers.BucketHandler;
import org.apache.hadoop.ozone.recon.api.handlers.EntityHandler;
import org.apache.hadoop.ozone.recon.api.types.BucketObjectDBInfo;
import org.apache.hadoop.ozone.recon.api.types.CountStats;
import org.apache.hadoop.ozone.recon.api.types.DUResponse;
import org.apache.hadoop.ozone.recon.api.types.EntityType;
import org.apache.hadoop.ozone.recon.api.types.FileSizeDistributionResponse;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.api.types.NamespaceSummaryResponse;
import org.apache.hadoop.ozone.recon.api.types.QuotaUsageResponse;
import org.apache.hadoop.ozone.recon.api.types.ResponseStatus;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;

public class BucketEntityHandler
extends EntityHandler {
    public BucketEntityHandler(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM, BucketHandler bucketHandler, String path) {
        super(reconNamespaceSummaryManager, omMetadataManager, reconSCM, bucketHandler, path);
    }

    @Override
    public NamespaceSummaryResponse getSummaryResponse() throws IOException {
        String[] names = this.getNames();
        assert (names.length == 2);
        long bucketObjectId = this.getBucketHandler().getBucketObjectId(names);
        CountStats countStats = new CountStats(-1, -1, this.getTotalDirCount(bucketObjectId), this.getTotalKeyCount(bucketObjectId));
        return NamespaceSummaryResponse.newBuilder().setEntityType(EntityType.BUCKET).setCountStats(countStats).setObjectDBInfo(this.getBucketObjDbInfo(names)).setStatus(ResponseStatus.OK).build();
    }

    private BucketObjectDBInfo getBucketObjDbInfo(String[] names) throws IOException {
        String volName = names[0];
        String bucketName = names[1];
        String bucketKey = this.getOmMetadataManager().getBucketKey(volName, bucketName);
        if (null == bucketKey) {
            return new BucketObjectDBInfo();
        }
        OmBucketInfo omBucketInfo = (OmBucketInfo)this.getOmMetadataManager().getBucketTable().getSkipCache((Object)bucketKey);
        if (null == omBucketInfo) {
            return new BucketObjectDBInfo();
        }
        return new BucketObjectDBInfo(omBucketInfo);
    }

    @Override
    public DUResponse getDuResponse(boolean listFile, boolean withReplica, boolean sortSubpaths) throws IOException {
        DUResponse duResponse = new DUResponse();
        duResponse.setPath(this.getNormalizedPath());
        long bucketObjectId = this.getBucketHandler().getBucketObjectId(this.getNames());
        NSSummary bucketNSSummary = this.getReconNamespaceSummaryManager().getNSSummary(bucketObjectId);
        if (bucketNSSummary == null) {
            if (withReplica) {
                duResponse.setSizeWithReplica(0L);
            }
            return duResponse;
        }
        Set<Long> bucketSubdirs = bucketNSSummary.getChildDir();
        duResponse.setKeySize(bucketNSSummary.getSizeOfFiles());
        List<DUResponse.DiskUsage> dirDUData = new ArrayList<DUResponse.DiskUsage>();
        long bucketDataSize = duResponse.getKeySize();
        long bucketDataSizeWithReplica = 0L;
        for (long subdirObjectId : bucketSubdirs) {
            NSSummary subdirNSSummary = this.getReconNamespaceSummaryManager().getNSSummary(subdirObjectId);
            String dirName = subdirNSSummary.getDirName();
            String subpath = BucketHandler.buildSubpath(this.getNormalizedPath(), dirName);
            DUResponse.DiskUsage diskUsage = new DUResponse.DiskUsage();
            diskUsage.setSubpath(subpath);
            long dataSize = this.getTotalSize(subdirObjectId);
            bucketDataSize += dataSize;
            if (withReplica) {
                long dirDU = this.getBucketHandler().calculateDUUnderObject(subdirObjectId);
                diskUsage.setSizeWithReplica(dirDU);
                bucketDataSizeWithReplica += dirDU;
            }
            diskUsage.setSize(dataSize);
            dirDUData.add(diskUsage);
        }
        if (listFile || withReplica) {
            bucketDataSizeWithReplica += this.getBucketHandler().handleDirectKeys(bucketObjectId, withReplica, listFile, dirDUData, this.getNormalizedPath());
        }
        if (withReplica) {
            duResponse.setSizeWithReplica(bucketDataSizeWithReplica);
        }
        duResponse.setCount(dirDUData.size());
        duResponse.setSize(bucketDataSize);
        if (sortSubpaths) {
            dirDUData = ReconUtils.sortDiskUsageDescendingWithLimit(dirDUData, 30);
        }
        duResponse.setDuData(dirDUData);
        return duResponse;
    }

    @Override
    public QuotaUsageResponse getQuotaResponse() throws IOException {
        QuotaUsageResponse quotaUsageResponse = new QuotaUsageResponse();
        String[] names = this.getNames();
        String bucketKey = this.getOmMetadataManager().getBucketKey(names[0], names[1]);
        OmBucketInfo bucketInfo = (OmBucketInfo)this.getOmMetadataManager().getBucketTable().getSkipCache((Object)bucketKey);
        long bucketObjectId = bucketInfo.getObjectID();
        long quotaInBytes = bucketInfo.getQuotaInBytes();
        long quotaUsedInBytes = this.getTotalSize(bucketObjectId);
        quotaUsageResponse.setQuota(quotaInBytes);
        quotaUsageResponse.setQuotaUsed(quotaUsedInBytes);
        return quotaUsageResponse;
    }

    @Override
    public FileSizeDistributionResponse getDistResponse() throws IOException {
        FileSizeDistributionResponse distResponse = new FileSizeDistributionResponse();
        long bucketObjectId = this.getBucketHandler().getBucketObjectId(this.getNames());
        int[] bucketFileSizeDist = this.getTotalFileSizeDist(bucketObjectId);
        distResponse.setFileSizeDist(bucketFileSizeDist);
        return distResponse;
    }
}

