/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.lib.lang;

import java.text.MessageFormat;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.ozone.lib.util.Check;

@InterfaceAudience.Private
public class XException
extends Exception {
    private ERROR error;

    private XException(ERROR error, String message, Throwable cause) {
        super(message, cause);
        this.error = error;
    }

    public XException(ERROR error, Object ... params) {
        this(Check.notNull(error, "error"), XException.format(error, params), XException.getCause(params));
    }

    public ERROR getError() {
        return this.error;
    }

    private static String format(ERROR error, Object ... args) {
        String template = error.getTemplate();
        if (template == null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                sb.append(" {").append(i).append('}');
            }
            template = sb.deleteCharAt(0).toString();
        }
        return error + ": " + MessageFormat.format(template, args);
    }

    private static Throwable getCause(Object ... params) {
        Throwable throwable = null;
        if (params != null && params.length > 0 && params[params.length - 1] instanceof Throwable) {
            throwable = (Throwable)params[params.length - 1];
        }
        return throwable;
    }

    public static interface ERROR {
        public String getTemplate();
    }
}

