/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.TableCacheMetrics;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.hadoop.hdds.utils.db.RocksDatabaseException;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;

@InterfaceStability.Evolving
public interface Table<KEY, VALUE> {
    public void put(KEY var1, VALUE var2) throws RocksDatabaseException, CodecException;

    public void putWithBatch(BatchOperation var1, KEY var2, VALUE var3) throws RocksDatabaseException, CodecException;

    public boolean isEmpty() throws RocksDatabaseException;

    public boolean isExist(KEY var1) throws RocksDatabaseException, CodecException;

    public VALUE get(KEY var1) throws RocksDatabaseException, CodecException;

    default public VALUE getSkipCache(KEY key) throws RocksDatabaseException, CodecException {
        throw new NotImplementedException("getSkipCache is not implemented");
    }

    default public VALUE getReadCopy(KEY key) throws RocksDatabaseException, CodecException {
        throw new NotImplementedException("getReadCopy is not implemented");
    }

    public VALUE getIfExist(KEY var1) throws RocksDatabaseException, CodecException;

    public void delete(KEY var1) throws RocksDatabaseException, CodecException;

    public void deleteWithBatch(BatchOperation var1, KEY var2) throws CodecException;

    public void deleteRangeWithBatch(BatchOperation var1, KEY var2, KEY var3) throws CodecException;

    public void deleteRange(KEY var1, KEY var2) throws RocksDatabaseException, CodecException;

    default public KeyValueIterator<KEY, VALUE> iterator() throws RocksDatabaseException, CodecException {
        return this.iterator(null, KeyValueIterator.Type.KEY_AND_VALUE);
    }

    default public KeyValueIterator<KEY, VALUE> iterator(KEY prefix) throws RocksDatabaseException, CodecException {
        return this.iterator(prefix, KeyValueIterator.Type.KEY_AND_VALUE);
    }

    public KeyValueIterator<KEY, VALUE> iterator(KEY var1, KeyValueIterator.Type var2) throws RocksDatabaseException, CodecException;

    default public TableIterator<KEY, KEY> keyIterator(KEY prefix) throws RocksDatabaseException, CodecException {
        KeyValueIterator<KEY, VALUE> i = this.iterator(prefix, KeyValueIterator.Type.KEY_ONLY);
        return TableIterator.convert(i, KeyValue::getKey);
    }

    default public TableIterator<KEY, KEY> keyIterator() throws RocksDatabaseException, CodecException {
        return this.keyIterator(null);
    }

    default public TableIterator<KEY, VALUE> valueIterator(KEY prefix) throws RocksDatabaseException, CodecException {
        KeyValueIterator<KEY, VALUE> i = this.iterator(prefix, KeyValueIterator.Type.VALUE_ONLY);
        return TableIterator.convert(i, KeyValue::getValue);
    }

    default public TableIterator<KEY, VALUE> valueIterator() throws RocksDatabaseException, CodecException {
        return this.valueIterator(null);
    }

    public String getName();

    public long getEstimatedKeyCount() throws RocksDatabaseException;

    default public void addCacheEntry(CacheKey<KEY> cacheKey, CacheValue<VALUE> cacheValue) {
        throw new NotImplementedException("addCacheEntry is not implemented");
    }

    default public void addCacheEntry(KEY cacheKey, long epoch) {
        this.addCacheEntry(new CacheKey<KEY>(cacheKey), CacheValue.get(epoch));
    }

    default public void addCacheEntry(KEY cacheKey, VALUE value, long epoch) {
        this.addCacheEntry(new CacheKey<KEY>(cacheKey), CacheValue.get(epoch, value));
    }

    default public CacheValue<VALUE> getCacheValue(CacheKey<KEY> cacheKey) {
        throw new NotImplementedException("getCacheValue is not implemented");
    }

    default public void cleanupCache(List<Long> epochs) {
        throw new NotImplementedException("cleanupCache is not implemented");
    }

    default public Iterator<Map.Entry<CacheKey<KEY>, CacheValue<VALUE>>> cacheIterator() {
        throw new NotImplementedException("cacheIterator is not implemented");
    }

    default public TableCacheMetrics createCacheMetrics() throws RocksDatabaseException {
        throw new NotImplementedException("getCacheValue is not implemented");
    }

    public List<KeyValue<KEY, VALUE>> getRangeKVs(KEY var1, int var2, KEY var3, MetadataKeyFilters.KeyPrefixFilter var4, boolean var5) throws RocksDatabaseException, CodecException;

    default public List<KeyValue<KEY, VALUE>> getRangeKVs(KEY startKey, int count, KEY prefix, MetadataKeyFilters.KeyPrefixFilter filter) throws RocksDatabaseException, CodecException {
        return this.getRangeKVs(startKey, count, prefix, filter, false);
    }

    default public List<KeyValue<KEY, VALUE>> getRangeKVs(KEY startKey, int count, KEY prefix) throws RocksDatabaseException, CodecException {
        return this.getRangeKVs(startKey, count, prefix, null);
    }

    public void deleteBatchWithPrefix(BatchOperation var1, KEY var2) throws RocksDatabaseException, CodecException;

    public void dumpToFileWithPrefix(File var1, KEY var2) throws RocksDatabaseException, CodecException;

    public void loadFromFile(File var1) throws RocksDatabaseException;

    public static <K, V> KeyValue<K, V> newKeyValue(K key, V value) {
        return Table.newKeyValue(key, value, -1);
    }

    public static <K, V> KeyValue<K, V> newKeyValue(K key, V value, int valueByteSize) {
        return new KeyValue(key, value, valueByteSize);
    }

    public static interface KeyValueIterator<KEY, VALUE>
    extends TableIterator<KEY, KeyValue<KEY, VALUE>> {

        public static enum Type {
            NEITHER,
            KEY_ONLY,
            VALUE_ONLY,
            KEY_AND_VALUE;


            boolean readKey() {
                return (this.ordinal() & KEY_ONLY.ordinal()) != 0;
            }

            boolean readValue() {
                return (this.ordinal() & VALUE_ONLY.ordinal()) != 0;
            }
        }
    }

    public static final class KeyValue<K, V> {
        private final K key;
        private final V value;
        private final int valueByteSize;

        private KeyValue(K key, V value, int valueByteSize) {
            this.key = key;
            this.value = value;
            this.valueByteSize = valueByteSize;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public int getValueByteSize() {
            return this.value != null ? this.valueByteSize : -1;
        }

        public String toString() {
            return "(key=" + this.key + ", value=" + this.value + ")";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof KeyValue)) {
                return false;
            }
            KeyValue that = (KeyValue)obj;
            return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue());
        }

        public int hashCode() {
            return Objects.hash(this.getKey(), this.getValue());
        }
    }
}

