/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.Closeable;
import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.utils.db.RocksDatabaseException;
import org.apache.hadoop.hdds.utils.db.managed.ManagedEnvOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedSstFileWriter;
import org.rocksdb.EnvOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDBException;

public class RDBSstFileWriter
implements Closeable {
    private ManagedSstFileWriter sstFileWriter;
    private File sstFile;
    private AtomicLong keyCounter;
    private ManagedOptions emptyOption = new ManagedOptions();
    private final ManagedEnvOptions emptyEnvOptions = new ManagedEnvOptions();

    public RDBSstFileWriter(File externalFile) throws RocksDatabaseException {
        this.sstFileWriter = new ManagedSstFileWriter((EnvOptions)this.emptyEnvOptions, (Options)this.emptyOption);
        this.keyCounter = new AtomicLong(0L);
        this.sstFile = externalFile;
        try {
            this.sstFileWriter.open(this.sstFile.getAbsolutePath());
        }
        catch (RocksDBException e) {
            this.closeOnFailure();
            throw new RocksDatabaseException("Failed to open " + this.sstFile, (Exception)((Object)e));
        }
    }

    public void put(byte[] key, byte[] value) throws RocksDatabaseException {
        try {
            this.sstFileWriter.put(key, value);
            this.keyCounter.incrementAndGet();
        }
        catch (RocksDBException e) {
            this.closeOnFailure();
            throw new RocksDatabaseException("Failed to put key (length=" + key.length + ") and value (length=" + value.length + "), sstFile=" + this.sstFile.getAbsolutePath(), (Exception)((Object)e));
        }
    }

    public void delete(byte[] key) throws RocksDatabaseException {
        try {
            this.sstFileWriter.delete(key);
            this.keyCounter.incrementAndGet();
        }
        catch (RocksDBException e) {
            this.closeOnFailure();
            throw new RocksDatabaseException("Failed to delete key (length=" + key.length + "), sstFile=" + this.sstFile.getAbsolutePath(), (Exception)((Object)e));
        }
    }

    @Override
    public void close() throws RocksDatabaseException {
        if (this.sstFileWriter != null) {
            try {
                if (this.keyCounter.get() > 0L) {
                    this.sstFileWriter.finish();
                }
            }
            catch (RocksDBException e) {
                throw new RocksDatabaseException("Failed to finish writing to " + this.sstFile, (Exception)((Object)e));
            }
            finally {
                this.closeResources();
            }
            this.keyCounter.set(0L);
        }
    }

    private void closeResources() {
        this.sstFileWriter.close();
        this.sstFileWriter = null;
        this.emptyOption.close();
        this.emptyEnvOptions.close();
    }

    private void closeOnFailure() {
        if (this.sstFileWriter != null) {
            this.closeResources();
        }
    }
}

