/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.freon;

import java.io.IOException;
import org.apache.hadoop.hdds.freon.FakeClusterTopology;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FakeScmContainerLocationProtocolClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(FakeScmContainerLocationProtocolClient.class);

    private FakeScmContainerLocationProtocolClient() {
    }

    public static StorageContainerLocationProtocolProtos.ScmContainerLocationResponse submitRequest(StorageContainerLocationProtocolProtos.ScmContainerLocationRequest req) throws IOException {
        try {
            if (req.getCmdType() == StorageContainerLocationProtocolProtos.Type.QueryNode) {
                StorageContainerLocationProtocolProtos.NodeQueryResponseProto.Builder builder = StorageContainerLocationProtocolProtos.NodeQueryResponseProto.newBuilder();
                for (HddsProtos.DatanodeDetailsProto datanode : FakeClusterTopology.INSTANCE.getAllDatanodes()) {
                    builder.addDatanodes(HddsProtos.Node.newBuilder().setNodeID(datanode).addNodeStates(HddsProtos.NodeState.HEALTHY).build());
                }
                return StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.newBuilder().setCmdType(StorageContainerLocationProtocolProtos.Type.QueryNode).setStatus(StorageContainerLocationProtocolProtos.ScmContainerLocationResponse.Status.OK).setNodeQueryResponse(builder.build()).build();
            }
            throw new IllegalArgumentException("Unsupported request. Fake answer is not implemented for " + req.getCmdType());
        }
        catch (Exception ex) {
            LOGGER.error("Error on creating fake SCM response", (Throwable)ex);
            return null;
        }
    }
}

