/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.hadoop.conf.ConfigRedactor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.conf.Reconfigurable;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.conf.ReconfigurationUtil;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReconfigurableBase
extends Configured
implements Reconfigurable {
    private static final Logger LOG = LoggerFactory.getLogger(ReconfigurableBase.class);
    private Thread reconfigThread = null;
    private volatile boolean shouldRun = true;
    private final Object reconfigLock = new Object();
    private long startTime = 0L;
    private long endTime = 0L;
    private Map<ReconfigurationUtil.PropertyChange, Optional<String>> status = null;
    private final Collection<Consumer<ReconfigurationTaskStatus>> reconfigurationCompleteCallbacks = new ArrayList<Consumer<ReconfigurationTaskStatus>>();

    public ReconfigurableBase(Configuration conf) {
        super(conf == null ? new Configuration() : conf);
    }

    protected abstract Configuration getNewConf();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReconfigurationTask() throws IOException {
        Object object = this.reconfigLock;
        synchronized (object) {
            if (!this.shouldRun) {
                String errorMessage = "The server is stopped.";
                LOG.warn(errorMessage);
                throw new IOException(errorMessage);
            }
            if (this.reconfigThread != null) {
                String errorMessage = "Another reconfiguration task is running.";
                LOG.warn(errorMessage);
                throw new IOException(errorMessage);
            }
            this.reconfigThread = new ReconfigurationThread(this);
            this.reconfigThread.setDaemon(true);
            this.reconfigThread.setName("Reconfiguration Task");
            this.reconfigThread.start();
            this.startTime = Time.now();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReconfigurationTaskStatus getReconfigurationTaskStatus() {
        Object object = this.reconfigLock;
        synchronized (object) {
            return this.reconfigThread != null ? new ReconfigurationTaskStatus(this.startTime, 0L, null) : new ReconfigurationTaskStatus(this.startTime, this.endTime, this.status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownReconfigurationTask() {
        Thread tempThread;
        Object object = this.reconfigLock;
        synchronized (object) {
            this.shouldRun = false;
            if (this.reconfigThread == null) {
                return;
            }
            tempThread = this.reconfigThread;
            this.reconfigThread = null;
        }
        try {
            tempThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reconfigureProperty(String property, String newVal) throws ReconfigurationException {
        if (this.isPropertyReconfigurable(property)) {
            LOG.info("changing property " + property + " to " + newVal);
            Configuration configuration = this.getConf();
            synchronized (configuration) {
                this.getConf().get(property);
                String effectiveValue = this.reconfigurePropertyImpl(property, newVal);
                if (newVal != null) {
                    this.getConf().set(property, effectiveValue);
                } else {
                    this.getConf().unset(property);
                }
            }
        } else {
            throw new ReconfigurationException(property, newVal, this.getConf().get(property));
        }
    }

    public abstract Collection<String> getReconfigurableProperties();

    public boolean isPropertyReconfigurable(String property) {
        return this.getReconfigurableProperties().contains(property);
    }

    protected abstract String reconfigurePropertyImpl(String var1, String var2) throws ReconfigurationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReconfigurationCompleteCallback(Consumer<ReconfigurationTaskStatus> callback) {
        Object object = this.reconfigLock;
        synchronized (object) {
            this.reconfigurationCompleteCallbacks.add(callback);
        }
    }

    private static class ReconfigurationThread
    extends Thread {
        private final ReconfigurableBase parent;

        ReconfigurationThread(ReconfigurableBase base) {
            this.parent = base;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info("Starting reconfiguration task.");
            Configuration oldConf = this.parent.getConf();
            Configuration newConf = this.parent.getNewConf();
            Collection changes = ReconfigurationUtil.getChangedProperties((Configuration)newConf, (Configuration)oldConf);
            HashMap results = Maps.newHashMap();
            ConfigRedactor oldRedactor = new ConfigRedactor(oldConf);
            ConfigRedactor newRedactor = new ConfigRedactor(newConf);
            for (ReconfigurationUtil.PropertyChange change : changes) {
                String errorMessage = null;
                String oldValRedacted = oldRedactor.redact(change.prop, change.oldVal);
                String newValRedacted = newRedactor.redact(change.prop, change.newVal);
                if (!this.parent.isPropertyReconfigurable(change.prop)) {
                    LOG.info(String.format("Property %s is not configurable: old value: %s, new value: %s", change.prop, oldValRedacted, newValRedacted));
                    continue;
                }
                LOG.info("Change property: " + change.prop + " from \"" + (change.oldVal == null ? "<default>" : oldValRedacted) + "\" to \"" + (change.newVal == null ? "<default>" : newValRedacted) + "\".");
                try {
                    String effectiveValue = this.parent.reconfigurePropertyImpl(change.prop, change.newVal);
                    if (change.newVal != null) {
                        oldConf.set(change.prop, effectiveValue);
                    } else {
                        oldConf.unset(change.prop);
                    }
                }
                catch (ReconfigurationException reconfException) {
                    Throwable cause = reconfException.getCause();
                    errorMessage = cause == null ? reconfException.getMessage() : cause.getMessage();
                    LOG.error("Failed to reconfigure property {}: {}", new Object[]{change.prop, errorMessage, reconfException});
                }
                results.put(change, Optional.ofNullable(errorMessage));
            }
            Object object = this.parent.reconfigLock;
            synchronized (object) {
                this.parent.endTime = Time.now();
                this.parent.status = Collections.unmodifiableMap(results);
                this.parent.reconfigThread = null;
                for (Consumer callback : this.parent.reconfigurationCompleteCallbacks) {
                    try {
                        callback.accept(this.parent.getReconfigurationTaskStatus());
                    }
                    catch (Exception e) {
                        LOG.warn("Reconfiguration complete callback threw exception", (Throwable)e);
                    }
                }
            }
        }
    }
}

