/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.metadata;

import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.utils.db.BatchOperationHandler;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.hadoop.hdds.utils.db.DBConfigFromFile;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBProfile;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.RocksDatabaseException;
import org.apache.hadoop.hdds.utils.db.managed.ManagedColumnFamilyOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedDBOptions;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.container.common.utils.db.DatanodeDBProfile;
import org.apache.hadoop.ozone.container.metadata.DBStoreManager;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.RocksDBException;

public abstract class AbstractRDBStore<DEF extends DBDefinition>
implements DBStoreManager {
    private final DEF dbDef;
    private final ManagedColumnFamilyOptions cfOptions;
    private static DatanodeDBProfile dbProfile;
    private volatile DBStore store;

    protected AbstractRDBStore(DEF dbDef, ConfigurationSource config, boolean openReadOnly) throws RocksDatabaseException, CodecException {
        dbProfile = DatanodeDBProfile.getProfile((DBProfile)config.getEnum("hdds.db.profile", (Enum)DBStoreBuilder.HDDS_DEFAULT_DB_PROFILE));
        this.cfOptions = this.getCfOptions(config);
        this.dbDef = dbDef;
        if (this.store == null) {
            ManagedDBOptions options = this.readDbOptionsFromFile(config);
            if (options == null) {
                options = dbProfile.getDBOptions();
            }
            options.setCreateIfMissing(true);
            options.setCreateMissingColumnFamilies(true);
            DatanodeConfiguration dc = (DatanodeConfiguration)((Object)config.getObject(DatanodeConfiguration.class));
            InfoLogLevel level = InfoLogLevel.valueOf((String)(dc.getRocksdbLogLevel() + "_LEVEL"));
            options.setInfoLogLevel(level);
            options.setMaxLogFileSize(dc.getRocksdbLogMaxFileSize());
            options.setKeepLogFileNum((long)dc.getRocksdbLogMaxFileNum());
            this.store = this.initDBStore(DBStoreBuilder.newBuilder((ConfigurationSource)config, dbDef, null, null).setDBOptions(options).setDefaultCFOptions(this.cfOptions).setOpenReadOnly(openReadOnly), options, config);
        }
    }

    private ManagedDBOptions readDbOptionsFromFile(ConfigurationSource config) throws RocksDatabaseException {
        ManagedDBOptions options;
        Path optionsPath = Paths.get(config.get("hdds.datanode.db.config.path", ""), new String[0]);
        try {
            options = DBConfigFromFile.readDBOptionsFromFile((Path)optionsPath);
        }
        catch (RocksDBException e) {
            throw new RocksDatabaseException("Error occured when reading RocksDBOptions from: " + optionsPath, (Exception)((Object)e));
        }
        return options;
    }

    private ManagedColumnFamilyOptions getCfOptions(ConfigurationSource config) throws RocksDatabaseException {
        ManagedColumnFamilyOptions cfoptionsFromFile;
        Path optionsPath = Paths.get(config.get("hdds.datanode.db.config.path", ""), new String[0]);
        try {
            cfoptionsFromFile = DBConfigFromFile.readCFOptionsFromFile((Path)optionsPath, (String)DBStoreBuilder.DEFAULT_COLUMN_FAMILY_NAME);
        }
        catch (RocksDBException ex) {
            throw new RocksDatabaseException("Error occured when reading CFOptions from: " + optionsPath, (Exception)((Object)ex));
        }
        ManagedColumnFamilyOptions usedCfOptions = cfoptionsFromFile != null ? cfoptionsFromFile : dbProfile.getColumnFamilyOptions(config);
        return usedCfOptions;
    }

    protected abstract DBStore initDBStore(DBStoreBuilder var1, ManagedDBOptions var2, ConfigurationSource var3) throws RocksDatabaseException, CodecException;

    @Override
    public synchronized void stop() {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    @Override
    public DBStore getStore() {
        return this.store;
    }

    @Override
    public synchronized boolean isClosed() {
        if (this.store == null) {
            return true;
        }
        return this.store.isClosed();
    }

    @Override
    public BatchOperationHandler getBatchHandler() {
        return this.store;
    }

    public void close() {
        this.store.close();
        this.cfOptions.close();
    }

    @Override
    public void flushDB() throws RocksDatabaseException {
        this.store.flushDB();
    }

    @Override
    public void flushLog(boolean sync) throws RocksDatabaseException {
        this.store.flushLog(sync);
    }

    @Override
    public void compactDB() throws RocksDatabaseException {
        this.store.compactDB();
    }

    @VisibleForTesting
    public DatanodeDBProfile getDbProfile() {
        return dbProfile;
    }

    protected DEF getDbDef() {
        return this.dbDef;
    }
}

