/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.CloseContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseContainerCommandHandler
implements CommandHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CloseContainerCommandHandler.class);
    private final AtomicLong invocationCount = new AtomicLong(0L);
    private final AtomicInteger queuedCount = new AtomicInteger(0);
    private final ThreadPoolExecutor executor;
    private final MutableRate opsLatencyMs;

    public CloseContainerCommandHandler(int threadPoolSize, int queueSize, String threadNamePrefix) {
        this.executor = new ThreadPoolExecutor(threadPoolSize, threadPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + "CloseContainerThread-%d").build());
        MetricsRegistry registry = new MetricsRegistry(CloseContainerCommandHandler.class.getSimpleName());
        this.opsLatencyMs = registry.newRate(StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closeContainerCommand + "Ms");
    }

    @Override
    public void handle(SCMCommand<?> command, OzoneContainer ozoneContainer, StateContext context, SCMConnectionManager connectionManager) {
        this.queuedCount.incrementAndGet();
        CompletableFuture.runAsync(() -> {
            this.invocationCount.incrementAndGet();
            long startTime = Time.monotonicNow();
            DatanodeDetails datanodeDetails = context.getParent().getDatanodeDetails();
            StorageContainerDatanodeProtocolProtos.CloseContainerCommandProto closeCommand = ((CloseContainerCommand)command).getProto();
            ContainerController controller = ozoneContainer.getController();
            long containerId = closeCommand.getContainerID();
            LOG.debug("Processing Close Container command container #{}", (Object)containerId);
            try {
                Container container = controller.getContainer(containerId);
                if (container == null) {
                    LOG.info("Container #{} does not exist in datanode. Its pipeline may have closed before it was created. Container close failed.", (Object)containerId);
                    return;
                }
                controller.markContainerForClose(containerId);
                switch (container.getContainerState()) {
                    case OPEN: 
                    case CLOSING: {
                        if (ozoneContainer.getWriteChannel().isExist(closeCommand.getPipelineID())) {
                            ContainerProtos.ContainerCommandRequestProto request = this.getContainerCommandRequestProto(datanodeDetails, closeCommand.getContainerID(), command.getEncodedToken());
                            ozoneContainer.getWriteChannel().submitRequest(request, closeCommand.getPipelineID());
                            return;
                        }
                        if (closeCommand.getForce()) {
                            controller.closeContainer(containerId);
                            return;
                        }
                        controller.quasiCloseContainer(containerId, "Ratis pipeline does not exist");
                        LOG.info("Marking Container {} quasi closed", (Object)containerId);
                        return;
                    }
                    case QUASI_CLOSED: {
                        if (!closeCommand.getForce()) return;
                        controller.closeContainer(containerId);
                        return;
                    }
                    case CLOSED: {
                        return;
                    }
                    case UNHEALTHY: 
                    case INVALID: {
                        LOG.debug("Cannot close the container #{}, the container is in {} state.", (Object)containerId, (Object)container.getContainerState());
                        return;
                    }
                }
                return;
            }
            catch (NotLeaderException e) {
                LOG.info("Follower cannot close container #{}.", (Object)containerId);
                return;
            }
            catch (IOException e) {
                LOG.error("Can't close container #{}", (Object)containerId, (Object)e);
                return;
            }
            finally {
                long endTime = Time.monotonicNow();
                this.opsLatencyMs.add(endTime - startTime);
            }
        }, this.executor).whenComplete((v, e) -> this.queuedCount.decrementAndGet());
    }

    private ContainerProtos.ContainerCommandRequestProto getContainerCommandRequestProto(DatanodeDetails datanodeDetails, long containerId, String encodedToken) {
        ContainerProtos.ContainerCommandRequestProto.Builder command = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        command.setCmdType(ContainerProtos.Type.CloseContainer);
        command.setTraceID(TracingUtil.exportCurrentSpan());
        command.setContainerID(containerId);
        command.setCloseContainer(ContainerProtos.CloseContainerRequestProto.getDefaultInstance());
        command.setDatanodeUuid(datanodeDetails.getUuidString());
        if (encodedToken != null) {
            command.setEncodedToken(encodedToken);
        }
        return command.build();
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closeContainerCommand;
    }

    @Override
    public int getInvocationCount() {
        return (int)this.invocationCount.get();
    }

    @Override
    public long getAverageRunTime() {
        return (long)this.opsLatencyMs.lastStat().mean();
    }

    @Override
    public long getTotalRunTime() {
        return (long)this.opsLatencyMs.lastStat().total();
    }

    @Override
    public int getQueuedCount() {
        return this.queuedCount.get();
    }

    @Override
    public int getThreadPoolMaxPoolSize() {
        return this.executor.getMaximumPoolSize();
    }

    @Override
    public int getThreadPoolActivePoolSize() {
        return this.executor.getActiveCount();
    }

    @Override
    public void stop() {
        this.executor.shutdownNow();
    }
}

