/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletContext;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveHandler;
import org.jboss.weld.environment.servlet.logging.WeldServletLogger;
import org.jboss.weld.environment.util.Files;

public class ServletContextBeanArchiveHandler
implements BeanArchiveHandler {
    protected static final String SLASH = "/";
    protected static final String DOT = ".";
    protected final ServletContext servletContext;

    public ServletContextBeanArchiveHandler(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public BeanArchiveBuilder handle(String path) {
        if (path.equals("/WEB-INF/classes")) {
            BeanArchiveBuilder builder = new BeanArchiveBuilder();
            this.handleResourcePath(path, path, builder);
            return builder;
        }
        if (path.startsWith("war:")) {
            try {
                URL url = new URL(path);
                InputStream in = url.openStream();
                if (in != null) {
                    BeanArchiveBuilder builder = new BeanArchiveBuilder();
                    this.handleLibrary(url, in, builder);
                    return builder;
                }
            }
            catch (IOException e) {
                WeldServletLogger.LOG.cannotHandleLibrary(path, e);
            }
        }
        return null;
    }

    protected void add(String rootPath, String subpath, BeanArchiveBuilder builder) {
        String className = this.toClassName(rootPath, subpath);
        builder.addClass(className);
        WeldServletLogger.LOG.tracev("Class discovered: {0}", (Object)className);
    }

    private void handleResourcePath(String rootPath, String resourcePath, BeanArchiveBuilder builder) {
        WeldServletLogger.LOG.debugv("Handle resource path: {0}", (Object)resourcePath);
        Set<String> subpaths = this.servletContext.getResourcePaths(resourcePath);
        if (subpaths != null && !subpaths.isEmpty()) {
            for (String subpath : subpaths) {
                if (subpath.endsWith(SLASH)) {
                    this.handleResourcePath(rootPath, subpath, builder);
                    continue;
                }
                if (!subpath.endsWith(".class")) continue;
                this.add(rootPath, subpath, builder);
            }
        }
    }

    private void handleLibrary(URL url, InputStream in, BeanArchiveBuilder builder) throws IOException {
        WeldServletLogger.LOG.debugv("Handle library: {0}", (Object)url);
        try (ZipInputStream zip = new ZipInputStream(in);){
            ZipEntry entry = null;
            while ((entry = zip.getNextEntry()) != null) {
                if (!Files.isClass(entry.getName())) continue;
                builder.addClass(Files.filenameToClassname(entry.getName()));
            }
        }
    }

    private String toClassName(String rootPath, String resourcePath) {
        return resourcePath.substring(rootPath.length() + 1, resourcePath.lastIndexOf(".class")).replace(SLASH, DOT);
    }
}

