/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RangerReadWriteLock {
    private static final RangerLock NO_OP_LOCK = new RangerLock(null);
    private final ReentrantReadWriteLock lock;

    public RangerReadWriteLock(boolean isUseLock) {
        this.lock = isUseLock ? new ReentrantReadWriteLock(true) : null;
    }

    public RangerLock getReadLock() {
        RangerLock ret;
        if (this.lock != null) {
            ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
            readLock.lock();
            ret = new RangerLock(readLock);
        } else {
            ret = NO_OP_LOCK;
        }
        return ret;
    }

    public RangerLock getWriteLock() {
        RangerLock ret;
        if (this.lock != null) {
            boolean isLocked = false;
            ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
            while (!isLocked) {
                isLocked = writeLock.tryLock();
                if (isLocked || this.lock.getReadLockCount() != 0) continue;
                Thread.yield();
            }
            ret = new RangerLock(writeLock);
        } else {
            ret = NO_OP_LOCK;
        }
        return ret;
    }

    public String toString() {
        if (this.lock != null) {
            return "ReadWriteLock:[" + this.lock.toString() + "], ReadLock:[" + this.lock.readLock().toString() + "], WriteLock:[" + this.lock.writeLock().toString() + "]";
        }
        return "ReadWriteLock:[null]";
    }

    public static final class RangerLock
    implements AutoCloseable {
        private final Lock lock;

        private RangerLock(Lock lock) {
            this.lock = lock;
        }

        @Override
        public void close() {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }

        public boolean isLockingEnabled() {
            return this.lock != null;
        }

        public String toString() {
            return this.lock == null ? "null" : this.lock.toString();
        }
    }
}

