/*
 * Decompiled with CFR 0.152.
 */
package morfologik.tools;

import com.beust.jcommander.Parameter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import morfologik.tools.ExitStatus;
import morfologik.tools.ExitStatusException;

final class BinaryInput {
    private static final String ARG_ACCEPT_BOM = "--accept-bom";
    private static final String ARG_ACCEPT_CR = "--accept-cr";
    private static final String ARG_IGNORE_EMPTY = "--ignore-empty";
    @Parameter(names={"--accept-bom"}, arity=0, description="Accept leading BOM bytes (UTF-8).")
    private boolean acceptBom;
    @Parameter(names={"--accept-cr"}, arity=0, description="Accept CR bytes in input sequences (\\r).")
    private boolean acceptCr;
    @Parameter(names={"--ignore-empty"}, arity=0, description="Ignore empty lines in the input.")
    private boolean ignoreEmpty;

    BinaryInput() {
    }

    public BinaryInput(boolean acceptBom, boolean acceptCr, boolean ignoreEmpty) {
        this.acceptBom = acceptBom;
        this.acceptCr = acceptCr;
        this.ignoreEmpty = ignoreEmpty;
    }

    List<byte[]> readBinarySequences(Path input, byte separator) throws IOException {
        final ArrayList<byte[]> sequences = new ArrayList<byte[]>();
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(input, new OpenOption[0]));){
            if (!this.acceptBom) {
                ((InputStream)is).mark(4);
                if (((InputStream)is).read() == 239 && ((InputStream)is).read() == 187 && ((InputStream)is).read() == 191) {
                    throw new ExitStatusException(ExitStatus.ERROR_OTHER, "The input starts with UTF-8 BOM bytes which is most likely not what you want. Use header-less UTF-8 file or override with %s.", ARG_ACCEPT_BOM);
                }
                ((InputStream)is).reset();
            }
            BinaryInput.forAllLines(is, separator, new LineConsumer(){

                @Override
                public byte[] process(byte[] buffer, int length) {
                    if (!BinaryInput.this.acceptCr && BinaryInput.hasCr(buffer, length)) {
                        throw new ExitStatusException(ExitStatus.ERROR_OTHER, "The input contains \\r byte (CR) which would be encoded as part of the automaton. If this is desired, use %s.", BinaryInput.ARG_ACCEPT_CR);
                    }
                    if (length == 0) {
                        if (!BinaryInput.this.ignoreEmpty) {
                            throw new ExitStatusException(ExitStatus.ERROR_OTHER, "The input contains empty sequences. If these can be ignored, use --ignore-empty.", new Object[0]);
                        }
                    } else {
                        sequences.add(Arrays.copyOf(buffer, length));
                    }
                    return buffer;
                }
            });
        }
        return sequences;
    }

    private static boolean hasCr(byte[] seq, int length) {
        int o = length;
        while (--o >= 0) {
            if (seq[o] != 13) continue;
            return true;
        }
        return false;
    }

    private static int forAllLines(InputStream is, byte separator, LineConsumer lineConsumer) throws IOException {
        int b;
        int lines = 0;
        byte[] buffer = new byte[]{};
        int pos = 0;
        while ((b = is.read()) != -1) {
            if (b == separator) {
                buffer = lineConsumer.process(buffer, pos);
                pos = 0;
                ++lines;
                continue;
            }
            if (pos >= buffer.length) {
                buffer = Arrays.copyOf(buffer, buffer.length + Math.max(10, buffer.length / 10));
            }
            buffer[pos++] = (byte)b;
        }
        if (pos > 0) {
            lineConsumer.process(buffer, pos);
            ++lines;
        }
        return lines;
    }

    private static interface LineConsumer {
        public byte[] process(byte[] var1, int var2);
    }
}

