/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.spi.support;

import java.io.File;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistenceapi.metadata.orm.annotation.EntityMappingsMetadataModelFactory;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public class EntityMappingsMetadataModelHelper {
    private final ClassPath bootPath;
    private final ClassPath moduleBootPath;
    private final ClassPath compilePath;
    private final ClassPath moduleCompilePath;
    private final ClassPath moduleClassPath;
    private final ClassPath sourcePath;
    private final ClassPath moduleSourcePath;
    private final Object modelLock;
    private File persistenceXml;
    private MetadataModel<EntityMappingsMetadata> model;

    public static EntityMappingsMetadataModelHelper create(ClassPath bootPath, ClassPath compilePath, ClassPath sourcePath) {
        return new EntityMappingsMetadataModelHelper(bootPath, ClassPath.EMPTY, compilePath, ClassPath.EMPTY, ClassPath.EMPTY, sourcePath, ClassPath.EMPTY);
    }

    private EntityMappingsMetadataModelHelper(ClassPath bootPath, ClassPath moduleBootPath, ClassPath compilePath, ClassPath moduleCompilePath, ClassPath moduleClassPath, ClassPath sourcePath, ClassPath moduleSourcePath) {
        this.bootPath = bootPath;
        this.moduleBootPath = moduleBootPath;
        this.compilePath = compilePath;
        this.moduleCompilePath = moduleCompilePath;
        this.moduleClassPath = moduleClassPath;
        this.sourcePath = sourcePath;
        this.moduleSourcePath = moduleSourcePath;
        this.modelLock = new Object();
    }

    public synchronized void changePersistenceXml(File newPersistenceXml) {
        this.persistenceXml = newPersistenceXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataModel<EntityMappingsMetadata> getEntityMappingsModel(String puName) {
        File pXml;
        EntityMappingsMetadataModelHelper entityMappingsMetadataModelHelper = this;
        synchronized (entityMappingsMetadataModelHelper) {
            pXml = this.persistenceXml;
        }
        if (pXml == null || FileUtil.toFileObject(pXml) == null) {
            return null;
        }
        return this.getDefaultEntityMappingsModel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataModel<EntityMappingsMetadata> getDefaultEntityMappingsModel(boolean withDeps) {
        Object object = this.modelLock;
        synchronized (object) {
            if (this.model == null) {
                this.model = EntityMappingsMetadataModelFactory.createMetadataModel(this.bootPath, this.moduleBootPath, this.compilePath, this.moduleCompilePath, this.moduleClassPath, this.sourcePath, this.moduleSourcePath);
            }
            return this.model;
        }
    }

    public static final class Builder {
        private final ClassPath bootPath;
        private ClassPath moduleBootPath = ClassPath.EMPTY;
        private ClassPath classPath = ClassPath.EMPTY;
        private ClassPath moduleCompilePath = ClassPath.EMPTY;
        private ClassPath moduleClassPath = ClassPath.EMPTY;
        private ClassPath sourcePath = ClassPath.EMPTY;
        private ClassPath moduleSourcePath = ClassPath.EMPTY;

        public Builder(@NonNull ClassPath bootPath) {
            Parameters.notNull("bootPath", bootPath);
            this.bootPath = bootPath;
        }

        @NonNull
        public Builder setModuleBootPath(@NullAllowed ClassPath moduleBootPath) {
            if (moduleBootPath == null) {
                moduleBootPath = ClassPath.EMPTY;
            }
            this.moduleBootPath = moduleBootPath;
            return this;
        }

        @NonNull
        public Builder setClassPath(@NullAllowed ClassPath classPath) {
            if (classPath == null) {
                classPath = ClassPath.EMPTY;
            }
            this.classPath = classPath;
            return this;
        }

        @NonNull
        public Builder setModuleCompilePath(@NullAllowed ClassPath moduleCompilePath) {
            if (moduleCompilePath == null) {
                moduleCompilePath = ClassPath.EMPTY;
            }
            this.moduleCompilePath = moduleCompilePath;
            return this;
        }

        @NonNull
        public Builder setModuleClassPath(@NullAllowed ClassPath moduleClassPath) {
            if (moduleClassPath == null) {
                moduleClassPath = ClassPath.EMPTY;
            }
            this.moduleClassPath = moduleClassPath;
            return this;
        }

        @NonNull
        public Builder setSourcePath(@NullAllowed ClassPath sourcePath) {
            if (sourcePath == null) {
                sourcePath = ClassPath.EMPTY;
            }
            this.sourcePath = sourcePath;
            return this;
        }

        @NonNull
        public Builder setModuleSourcePath(@NullAllowed ClassPath moduleSourcePath) {
            if (moduleSourcePath == null) {
                moduleSourcePath = ClassPath.EMPTY;
            }
            this.moduleSourcePath = moduleSourcePath;
            return this;
        }

        @NonNull
        public EntityMappingsMetadataModelHelper build() {
            return new EntityMappingsMetadataModelHelper(this.bootPath, this.moduleBootPath, this.classPath, this.moduleCompilePath, this.moduleClassPath, this.sourcePath, this.moduleSourcePath);
        }
    }
}

