package org.apache.maven.plugin.coreit;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

/**
 * Dumps a properties resource from the classpath to a user-supplied output file.
 * 
 * @goal touch
 * @phase validate
 * 
 * @author Benjamin Bentmann
 */
public class TouchMojo
    extends AbstractMojo
{

    /**
     * The path to the output file.
     * 
     * @parameter expression="${touch.outputFile}" default-value="target/touch.properties"
     */
    private File outputFile;

    /**
     * Runs this mojo.
     * 
     * @throws MojoExecutionException If the output file could not be created.
     */
    public void execute()
        throws MojoExecutionException
    {
        URL url = getClass().getResource( "/mng4353.properties" );

        getLog().info( "[MAVEN-CORE-IT-LOG] Loaded resource: " + url );

        Properties props = new Properties();

        try
        {
            if ( url != null )
            {
                props.load( url.openStream() );
            }
        }
        catch ( IOException e )
        {
            throw new MojoExecutionException( "Resource file could not be read: " + url, e );
        }

        getLog().info( "[MAVEN-CORE-IT-LOG] Creating output file: " + outputFile );

        try
        {
            outputFile.getParentFile().mkdirs();

            FileOutputStream os = new FileOutputStream( outputFile );
            try
            {
                props.store( os, "[MAVEN-CORE-IT-LOG]" );
            }
            finally
            {
                os.close();
            }
        }
        catch ( IOException e )
        {
            throw new MojoExecutionException( "Output file could not be created: " + outputFile, e );
        }

        getLog().info( "[MAVEN-CORE-IT-LOG] Created output file: " + outputFile );
    }

}
