/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.http;

import java.util.Base64;
import java.util.Map;
import org.apache.kyuubi.shade.io.vertx.core.http.Http2Settings;
import org.apache.kyuubi.shade.io.vertx.core.json.JsonObject;
import org.apache.kyuubi.shade.io.vertx.core.json.impl.JsonUtil;

public class Http2SettingsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, Http2Settings obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "headerTableSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHeaderTableSize(((Number)member.getValue()).longValue());
                    break;
                }
                case "initialWindowSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setInitialWindowSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxConcurrentStreams": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxConcurrentStreams(((Number)member.getValue()).longValue());
                    break;
                }
                case "maxFrameSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxFrameSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxHeaderListSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxHeaderListSize(((Number)member.getValue()).longValue());
                    break;
                }
                case "pushEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setPushEnabled((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(Http2Settings obj, JsonObject json) {
        Http2SettingsConverter.toJson(obj, json.getMap());
    }

    static void toJson(Http2Settings obj, Map<String, Object> json) {
        json.put("headerTableSize", obj.getHeaderTableSize());
        json.put("initialWindowSize", obj.getInitialWindowSize());
        json.put("maxConcurrentStreams", obj.getMaxConcurrentStreams());
        json.put("maxFrameSize", obj.getMaxFrameSize());
        json.put("maxHeaderListSize", obj.getMaxHeaderListSize());
        json.put("pushEnabled", obj.isPushEnabled());
    }
}

