/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.dev.failsafe;

import java.time.Duration;
import org.apache.kyuubi.shade.dev.failsafe.CircuitBreaker;
import org.apache.kyuubi.shade.dev.failsafe.CircuitBreakerConfig;
import org.apache.kyuubi.shade.dev.failsafe.DelayablePolicyBuilder;
import org.apache.kyuubi.shade.dev.failsafe.PolicyListeners;
import org.apache.kyuubi.shade.dev.failsafe.event.CircuitBreakerStateChangedEvent;
import org.apache.kyuubi.shade.dev.failsafe.event.EventListener;
import org.apache.kyuubi.shade.dev.failsafe.internal.CircuitBreakerImpl;
import org.apache.kyuubi.shade.dev.failsafe.internal.util.Assert;
import org.apache.kyuubi.shade.dev.failsafe.internal.util.Durations;

public class CircuitBreakerBuilder<R>
extends DelayablePolicyBuilder<CircuitBreakerBuilder<R>, CircuitBreakerConfig<R>, R>
implements PolicyListeners<CircuitBreakerBuilder<R>, R> {
    CircuitBreakerBuilder() {
        super(new CircuitBreakerConfig());
        ((CircuitBreakerConfig)this.config).delay = Duration.ofMinutes(1L);
        ((CircuitBreakerConfig)this.config).failureThreshold = 1;
        ((CircuitBreakerConfig)this.config).failureThresholdingCapacity = 1;
    }

    CircuitBreakerBuilder(CircuitBreakerConfig<R> config) {
        super(new CircuitBreakerConfig<R>(config));
    }

    public CircuitBreaker<R> build() {
        return new CircuitBreakerImpl(new CircuitBreakerConfig((CircuitBreakerConfig)this.config));
    }

    public CircuitBreakerBuilder<R> onClose(EventListener<CircuitBreakerStateChangedEvent> listener) {
        ((CircuitBreakerConfig)this.config).closeListener = Assert.notNull(listener, "runnable");
        return this;
    }

    public CircuitBreakerBuilder<R> onHalfOpen(EventListener<CircuitBreakerStateChangedEvent> listener) {
        ((CircuitBreakerConfig)this.config).halfOpenListener = Assert.notNull(listener, "runnable");
        return this;
    }

    public CircuitBreakerBuilder<R> onOpen(EventListener<CircuitBreakerStateChangedEvent> listener) {
        ((CircuitBreakerConfig)this.config).openListener = Assert.notNull(listener, "listener");
        return this;
    }

    @Override
    public CircuitBreakerBuilder<R> withDelay(Duration delay) {
        Assert.notNull(delay, "delay");
        delay = Durations.ofSafeNanos(delay);
        Assert.isTrue(delay.toNanos() >= 0L, "delay must be >= 0", new Object[0]);
        ((CircuitBreakerConfig)this.config).delay = delay;
        return this;
    }

    public CircuitBreakerBuilder<R> withFailureThreshold(int failureThreshold) {
        return this.withFailureThreshold(failureThreshold, failureThreshold);
    }

    public CircuitBreakerBuilder<R> withFailureThreshold(int failureThreshold, int failureThresholdingCapacity) {
        Assert.isTrue(failureThreshold >= 1, "failureThreshold must be >= 1", new Object[0]);
        Assert.isTrue(failureThresholdingCapacity >= 1, "failureThresholdingCapacity must be >= 1", new Object[0]);
        Assert.isTrue(failureThresholdingCapacity >= failureThreshold, "failureThresholdingCapacity must be >= failureThreshold", new Object[0]);
        ((CircuitBreakerConfig)this.config).failureThreshold = failureThreshold;
        ((CircuitBreakerConfig)this.config).failureThresholdingCapacity = failureThresholdingCapacity;
        return this;
    }

    public CircuitBreakerBuilder<R> withFailureThreshold(int failureThreshold, Duration failureThresholdingPeriod) {
        return this.withFailureThreshold(failureThreshold, failureThreshold, failureThresholdingPeriod);
    }

    public CircuitBreakerBuilder<R> withFailureThreshold(int failureThreshold, int failureExecutionThreshold, Duration failureThresholdingPeriod) {
        Assert.isTrue(failureThreshold >= 1, "failureThreshold must be >= 1", new Object[0]);
        Assert.isTrue(failureExecutionThreshold >= failureThreshold, "failureExecutionThreshold must be >= failureThreshold", new Object[0]);
        this.assertFailureExecutionThreshold(failureExecutionThreshold);
        this.assertFailureThresholdingPeriod(failureThresholdingPeriod);
        ((CircuitBreakerConfig)this.config).failureThreshold = failureThreshold;
        ((CircuitBreakerConfig)this.config).failureThresholdingCapacity = failureThreshold;
        ((CircuitBreakerConfig)this.config).failureExecutionThreshold = failureExecutionThreshold;
        ((CircuitBreakerConfig)this.config).failureThresholdingPeriod = failureThresholdingPeriod;
        return this;
    }

    public CircuitBreakerBuilder<R> withFailureRateThreshold(int failureRateThreshold, int failureExecutionThreshold, Duration failureThresholdingPeriod) {
        Assert.isTrue(failureRateThreshold >= 1 && failureRateThreshold <= 100, "failureRateThreshold must be between 1 and 100", new Object[0]);
        this.assertFailureExecutionThreshold(failureExecutionThreshold);
        this.assertFailureThresholdingPeriod(failureThresholdingPeriod);
        ((CircuitBreakerConfig)this.config).failureRateThreshold = failureRateThreshold;
        ((CircuitBreakerConfig)this.config).failureExecutionThreshold = failureExecutionThreshold;
        ((CircuitBreakerConfig)this.config).failureThresholdingPeriod = failureThresholdingPeriod;
        return this;
    }

    private void assertFailureExecutionThreshold(int failureExecutionThreshold) {
        Assert.isTrue(failureExecutionThreshold >= 1, "failureExecutionThreshold must be >= 1", new Object[0]);
    }

    private void assertFailureThresholdingPeriod(Duration failureThresholdingPeriod) {
        Assert.notNull(failureThresholdingPeriod, "failureThresholdingPeriod");
        Assert.isTrue(failureThresholdingPeriod.toMillis() >= 10L, "failureThresholdingPeriod must be >= 10 ms", new Object[0]);
    }

    public CircuitBreakerBuilder<R> withSuccessThreshold(int successThreshold) {
        return this.withSuccessThreshold(successThreshold, successThreshold);
    }

    public CircuitBreakerBuilder<R> withSuccessThreshold(int successThreshold, int successThresholdingCapacity) {
        Assert.isTrue(successThreshold >= 1, "successThreshold must be >= 1", new Object[0]);
        Assert.isTrue(successThresholdingCapacity >= 1, "successThresholdingCapacity must be >= 1", new Object[0]);
        Assert.isTrue(successThresholdingCapacity >= successThreshold, "successThresholdingCapacity must be >= successThreshold", new Object[0]);
        ((CircuitBreakerConfig)this.config).successThreshold = successThreshold;
        ((CircuitBreakerConfig)this.config).successThresholdingCapacity = successThresholdingCapacity;
        return this;
    }
}

