/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service.authentication.ldap;

import java.io.Serializable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.authentication.ldap.DirSearch;
import org.apache.kyuubi.service.authentication.ldap.LdapUtils$;
import org.apache.kyuubi.service.authentication.ldap.Query;
import org.apache.kyuubi.service.authentication.ldap.QueryFactory;
import org.apache.kyuubi.service.authentication.ldap.SearchResultHandler;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005-e\u0001\u0002\f\u0018\u0001\u0011B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!)q\t\u0001C\u0001\u0011\"9A\n\u0001b\u0001\n\u001bi\u0005BB.\u0001A\u00035a\nC\u0004]\u0001\t\u0007IQB/\t\r\t\u0004\u0001\u0015!\u0004_\u0011\u001d\u0019\u0007A1A\u0005\u000euCa\u0001\u001a\u0001!\u0002\u001bq\u0006bB3\u0001\u0005\u0004%i!\u0018\u0005\u0007M\u0002\u0001\u000bQ\u00020\t\u000f\u001d\u0004!\u0019!C\u0007Q\"1A\u000e\u0001Q\u0001\u000e%DQ!\u001c\u0001\u0005B9DQA\u001d\u0001\u0005BMDq!a\u0007\u0001\t\u0013\ti\u0002C\u0004\u0002>\u0001!\t%a\u0010\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L!9\u0011Q\f\u0001\u0005B\u0005}\u0003bBA5\u0001\u0011\u0005\u00131\u000e\u0005\b\u0003k\u0002A\u0011BA<\u0005)aE-\u00199TK\u0006\u00148\r\u001b\u0006\u00031e\tA\u0001\u001c3ba*\u0011!dG\u0001\u000fCV$\b.\u001a8uS\u000e\fG/[8o\u0015\taR$A\u0004tKJ4\u0018nY3\u000b\u0005yy\u0012AB6zkV\u0014\u0017N\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0015j\u0013\u0007\u0005\u0002'W5\tqE\u0003\u0002)S\u0005!A.\u00198h\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001L\u0014\u0003\r=\u0013'.Z2u!\tqs&D\u0001\u0018\u0013\t\u0001tCA\u0005ESJ\u001cV-\u0019:dQB\u0011!gM\u0007\u0002;%\u0011A'\b\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0011\u0005]RT\"\u0001\u001d\u000b\u0005ej\u0012AB2p]\u001aLw-\u0003\u0002<q\tQ1*_;vE&\u001cuN\u001c4\u0002\u0007\r$\b\u0010\u0005\u0002?\u000b6\tqH\u0003\u0002A\u0003\u0006IA-\u001b:fGR|'/\u001f\u0006\u0003\u0005\u000e\u000baA\\1nS:<'\"\u0001#\u0002\u000b)\fg/\u0019=\n\u0005\u0019{$A\u0003#je\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"2!\u0013&L!\tq\u0003\u0001C\u00036\u0007\u0001\u0007a\u0007C\u0003=\u0007\u0001\u0007Q(\u0001\u0004cCN,GI\\\u000b\u0002\u001dB\u0011q\n\u0017\b\u0003!Z\u0003\"!\u0015+\u000e\u0003IS!aU\u0012\u0002\rq\u0012xn\u001c;?\u0015\u0005)\u0016!B:dC2\f\u0017BA,U\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011L\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]#\u0016a\u00022bg\u0016$e\u000eI\u0001\u000bOJ|W\u000f\u001d\"bg\u0016\u001cX#\u00010\u0011\u0007}\u0003g*D\u0001U\u0013\t\tGKA\u0003BeJ\f\u00170A\u0006he>,\bOQ1tKN\u0004\u0013\u0001D;tKJ\u0004\u0016\r\u001e;fe:\u001c\u0018!D;tKJ\u0004\u0016\r\u001e;fe:\u001c\b%A\u0005vg\u0016\u0014()Y:fg\u0006QQo]3s\u0005\u0006\u001cXm\u001d\u0011\u0002\u000fE,XM]5fgV\t\u0011\u000e\u0005\u0002/U&\u00111n\u0006\u0002\r#V,'/\u001f$bGR|'/_\u0001\tcV,'/[3tA\u0005)1\r\\8tKR\tq\u000e\u0005\u0002`a&\u0011\u0011\u000f\u0016\u0002\u0005+:LG/\u0001\u0006gS:$Wk]3s\t:$\"A\u0014;\t\u000bU|\u0001\u0019\u0001(\u0002\tU\u001cXM\u001d\u0015\u0004\u001f]t\bcA0yu&\u0011\u0011\u0010\u0016\u0002\u0007i\"\u0014xn^:\u0011\u0005mdX\"A!\n\u0005u\f%a\u0004(b[&tw-\u0012=dKB$\u0018n\u001c82\t\u0015z\u0018q\u0003\u0016\u0005\u0003\u0003\t)\u0001E\u0002'\u0003\u0007I!!W\u0014,\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003'i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0005[\u0016$\u0018MC\u0002\u0002\u0012Q\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t)\"a\u0003\u0003\u0015\u0011,g-Y;mi\u0006\u0013x-\t\u0002\u0002\u001a\u0005\u0001\u0011a\u00044j]\u0012$eNQ=QCR$XM\u001d8\u0015\u000by\u000by\"!\u000e\t\u000f\u0005\u0005\u0002\u00031\u0001\u0002$\u0005A\u0001/\u0019;uKJt7\u000fE\u0003\u0002&\u0005=bJ\u0004\u0003\u0002(\u0005-bbA)\u0002*%\tQ+C\u0002\u0002.Q\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u00022\u0005M\"aA*fc*\u0019\u0011Q\u0006+\t\r\u0005]\u0002\u00031\u0001O\u0003\u0011q\u0017-\\3)\tA9\u00181H\u0019\u0005K}\f9\"A\u0006gS:$wI]8va\u0012sGc\u0001(\u0002B!1\u00111I\tA\u00029\u000bQa\u001a:pkBDC!E<\u0002HE\"Qe`A\f\u0003MI7/V:fe6+WNY3s\u001f\u001a<%o\\;q)\u0019\ti%a\u0015\u0002VA\u0019q,a\u0014\n\u0007\u0005ECKA\u0004C_>dW-\u00198\t\u000bU\u0014\u0002\u0019\u0001(\t\r\u0005]#\u00031\u0001O\u0003\u001d9'o\\;q\t:DCAE<\u0002\\E\"Qe`A\f\u0003E1\u0017N\u001c3He>,\bo\u001d$peV\u001bXM\u001d\u000b\u0004=\u0006\u0005\u0004BBA2'\u0001\u0007a*\u0001\u0004vg\u0016\u0014HI\u001c\u0015\u0005']\f9'\r\u0003&\u007f\u0006]\u0011AE3yK\u000e,H/Z\"vgR|W.U;fef$2AXA7\u0011\u0019\ty\u0007\u0006a\u0001\u001d\u0006)\u0011/^3ss\"\"Ac^A:c\u0011)s0a\u0006\u0002\u000f\u0015DXmY;uKR1\u0011\u0011PA@\u0003\u0007\u00032ALA>\u0013\r\tih\u0006\u0002\u0014'\u0016\f'o\u00195SKN,H\u000e\u001e%b]\u0012dWM\u001d\u0005\u0007\u0003\u0003+\u0002\u0019\u00010\u0002\u000f\t\f7/\u001a#og\"9\u0011qN\u000bA\u0002\u0005\u0015\u0005c\u0001\u0018\u0002\b&\u0019\u0011\u0011R\f\u0003\u000bE+XM]=")
public class LdapSearch
implements DirSearch,
Logging {
    private final DirContext ctx;
    private final String baseDn;
    private final String[] groupBases;
    private final String[] userPatterns;
    private final String[] userBases;
    private final QueryFactory queries;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private final String baseDn() {
        return this.baseDn;
    }

    private final String[] groupBases() {
        return this.groupBases;
    }

    private final String[] userPatterns() {
        return this.userPatterns;
    }

    private final String[] userBases() {
        return this.userBases;
    }

    private final QueryFactory queries() {
        return this.queries;
    }

    @Override
    public void close() {
        try {
            this.ctx.close();
        }
        catch (NamingException e) {
            this.warn((Function0<Object>)(Function0 & Serializable)() -> "Exception when closing LDAP context:", e);
        }
    }

    @Override
    public String findUserDn(String user) throws NamingException {
        ObjectRef allLdapNames = ObjectRef.create(null);
        if (LdapUtils$.MODULE$.isDn(user)) {
            String userBaseDn = LdapUtils$.MODULE$.extractBaseDn(user);
            String userRdn = LdapUtils$.MODULE$.extractFirstRdn(user);
            allLdapNames.elem = this.execute((String[])((Object[])new String[]{userBaseDn}), this.queries().findUserDnByRdn(userRdn)).getAllLdapNames();
        } else {
            allLdapNames.elem = this.findDnByPattern((Seq<String>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)this.userPatterns()), user);
            if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])((String[])allLdapNames.elem)))) {
                allLdapNames.elem = this.execute(this.userBases(), this.queries().findUserDnByName(user)).getAllLdapNames();
            }
        }
        if (((String[])allLdapNames.elem).length == 1) {
            return (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])((String[])allLdapNames.elem)));
        }
        this.info((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(73).append("Expected exactly one user result for the user: ").append(user).append(", ").append("but got ").append(((String[])allLdapNames$1.elem).length).append(". Returning null").toString());
        this.debug((Function0<Object>)(Function0 & Serializable)() -> "Matched users: $allLdapNames");
        return null;
    }

    private String[] findDnByPattern(Seq<String> patterns, String name) throws NamingException {
        String[] stringArray;
        Object object = new Object();
        try {
            patterns.foreach((Function1 & Serializable)pattern -> {
                LdapSearch.$anonfun$findDnByPattern$1(this, name, object, pattern);
                return BoxedUnit.UNIT;
            });
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                stringArray = (String[])ex.value();
            }
            throw ex;
        }
        return stringArray;
    }

    @Override
    public String findGroupDn(String group) throws NamingException {
        return this.execute(this.groupBases(), this.queries().findGroupDnById(group)).getSingleLdapName();
    }

    @Override
    public boolean isUserMemberOfGroup(String user, String groupDn) throws NamingException {
        String userId = LdapUtils$.MODULE$.extractUserName(user);
        return this.execute(this.userBases(), this.queries().isUserMemberOfGroup(userId, groupDn)).hasSingleResult();
    }

    @Override
    public String[] findGroupsForUser(String userDn) throws NamingException {
        String userName = LdapUtils$.MODULE$.extractUserName(userDn);
        return this.execute(this.groupBases(), this.queries().findGroupsForUser(userName, userDn)).getAllLdapNames();
    }

    @Override
    public String[] executeCustomQuery(String query) throws NamingException {
        return this.execute((String[])((Object[])new String[]{this.baseDn()}), this.queries().customQuery(query)).getAllLdapNamesAndAttributes();
    }

    private SearchResultHandler execute(String[] baseDns, Query query) {
        ArrayBuffer searchResults = new ArrayBuffer();
        this.debug((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(36).append("Executing a query: '").append(query.filter()).append("' with base DNs ").append(Predef$.MODULE$.wrapRefArray((Object[])baseDns).mkString(",")).toString());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])baseDns), (Function1 & Serializable)baseDn -> {
            BoxedUnit boxedUnit;
            block3: {
                try {
                    NamingEnumeration<SearchResult> searchResult = $this.ctx.search((String)baseDn, query.filter(), query.controls());
                    if (searchResult != null) {
                        boxedUnit = searchResults.$plus$eq(searchResult);
                        break block3;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (NamingException ex) {
                    this.debug((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(47).append("Exception happened for query '").append(query.filter()).append("' with base DN '").append((String)baseDn).append("'").toString(), ex);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return boxedUnit;
        });
        return new SearchResultHandler((NamingEnumeration[])searchResults.toArray(ClassTag$.MODULE$.apply(NamingEnumeration.class)));
    }

    public static final /* synthetic */ void $anonfun$findDnByPattern$1(LdapSearch $this, String name$1, Object nonLocalReturnKey1$1, String pattern) {
        String baseDnFromPattern = LdapUtils$.MODULE$.extractBaseDn(pattern);
        String rdn = LdapUtils$.MODULE$.extractFirstRdn(pattern).replaceAll("%s", name$1);
        String[] names = $this.execute((String[])((Object[])new String[]{baseDnFromPattern}), $this.queries().findDnByPattern(rdn)).getAllLdapNames();
        if (!ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])names))) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)names);
        }
    }

    public LdapSearch(KyuubiConf conf, DirContext ctx) {
        this.ctx = ctx;
        Logging.$init$(this);
        this.baseDn = (String)((Option)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_BASE_DN())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.groupBases = LdapUtils$.MODULE$.patternsToBaseDns(LdapUtils$.MODULE$.parseDnPatterns(conf, KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_GROUP_DN_PATTERN()));
        this.userPatterns = LdapUtils$.MODULE$.parseDnPatterns(conf, KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_USER_DN_PATTERN());
        this.userBases = LdapUtils$.MODULE$.patternsToBaseDns(this.userPatterns());
        this.queries = new QueryFactory(conf);
    }
}

