/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.etcd.jetcd.support;

import org.apache.kyuubi.shade.io.grpc.Status;

public final class Errors {
    public static final String NO_LEADER_ERROR_MESSAGE = "etcdserver: no leader";
    public static final String INVALID_AUTH_TOKEN_ERROR_MESSAGE = "etcdserver: invalid auth token";
    public static final String ERROR_AUTH_STORE_OLD = "etcdserver: revision of auth store is old";

    private Errors() {
    }

    public static boolean isRetryable(Status status) {
        return Status.UNAVAILABLE.getCode().equals((Object)status.getCode()) || Errors.isInvalidTokenError(status);
    }

    public static boolean isInvalidTokenError(Throwable e) {
        Status status = Status.fromThrowable(e);
        return Errors.isInvalidTokenError(status);
    }

    public static boolean isInvalidTokenError(Status status) {
        return (status.getCode() == Status.Code.UNAUTHENTICATED || status.getCode() == Status.Code.UNKNOWN) && INVALID_AUTH_TOKEN_ERROR_MESSAGE.equals(status.getDescription());
    }

    public static boolean isAuthStoreExpired(Throwable e) {
        Status status = Status.fromThrowable(e);
        return Errors.isAuthStoreExpired(status);
    }

    public static boolean isAuthStoreExpired(Status status) {
        return (status.getCode() == Status.Code.UNAUTHENTICATED || status.getCode() == Status.Code.INVALID_ARGUMENT) && ERROR_AUTH_STORE_OLD.equals(status.getDescription());
    }

    public static boolean isHaltError(Status status) {
        return status.getCode() != Status.Code.UNAVAILABLE && status.getCode() != Status.Code.INTERNAL;
    }

    public static boolean isNoLeaderError(Status status) {
        return status.getCode() == Status.Code.UNAVAILABLE && NO_LEADER_ERROR_MESSAGE.equals(status.getDescription());
    }
}

