/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl.synccontext.named;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.DiscriminatingNameMapper;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.FileGAVNameMapper;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.GAVNameMapper;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactorySelectorSupport;
import shaded.org.eclipse.aether.internal.impl.synccontext.named.StaticNameMapper;
import shaded.org.eclipse.aether.named.NamedLockFactory;
import shaded.org.eclipse.aether.named.providers.FileLockNamedLockFactory;
import shaded.org.eclipse.aether.named.providers.LocalReadWriteLockNamedLockFactory;
import shaded.org.eclipse.aether.named.providers.LocalSemaphoreNamedLockFactory;
import shaded.org.eclipse.aether.named.providers.NoopNamedLockFactory;

@Singleton
@Named
public final class SimpleNamedLockFactorySelector
extends NamedLockFactorySelectorSupport {
    private static final Map<String, NamedLockFactory> FACTORIES = new HashMap<String, NamedLockFactory>();
    private static final Map<String, NameMapper> NAME_MAPPERS;

    public SimpleNamedLockFactorySelector() {
        this(FACTORIES, NAME_MAPPERS);
    }

    @Inject
    public SimpleNamedLockFactorySelector(Map<String, NamedLockFactory> factories, Map<String, NameMapper> nameMappers) {
        super(factories, "rwlock-local", nameMappers, "gav");
    }

    static {
        FACTORIES.put("noop", new NoopNamedLockFactory());
        FACTORIES.put("rwlock-local", new LocalReadWriteLockNamedLockFactory());
        FACTORIES.put("semaphore-local", new LocalSemaphoreNamedLockFactory());
        FACTORIES.put("file-lock", new FileLockNamedLockFactory());
        NAME_MAPPERS = new HashMap<String, NameMapper>();
        NAME_MAPPERS.put("static", new StaticNameMapper());
        NAME_MAPPERS.put("gav", new GAVNameMapper());
        NAME_MAPPERS.put("discriminating", new DiscriminatingNameMapper(new GAVNameMapper()));
        NAME_MAPPERS.put("file-gav", new FileGAVNameMapper());
    }
}

