/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor;

import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.internals.ApiUtils;
import org.apache.kafka.streams.processor.Cancellable;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateRestoreCallback;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.processor.internals.ClientUtils;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.metrics.TaskMetrics;

@Deprecated
public class MockProcessorContext
implements ProcessorContext,
RecordCollector.Supplier {
    private final StreamsMetricsImpl metrics;
    private final TaskId taskId;
    private final StreamsConfig config;
    private final File stateDir;
    private String topic;
    private Integer partition;
    private Long offset;
    private Headers headers;
    private Long recordTimestamp;
    private Long currentSystemTimeMs;
    private Long currentStreamTimeMs;
    private final Map<String, StateStore> stateStores = new HashMap<String, StateStore>();
    private final List<CapturedPunctuator> punctuators = new LinkedList<CapturedPunctuator>();
    private final List<CapturedForward> capturedForwards = new LinkedList<CapturedForward>();
    private boolean committed = false;

    public MockProcessorContext() {
        this(new Properties(){
            {
                this.put("application.id", "");
                this.put("bootstrap.servers", "mock-localhost:9092");
            }
        }, new TaskId(0, 0), null);
    }

    public MockProcessorContext(Properties config) {
        this(config, new TaskId(0, 0), null);
    }

    public MockProcessorContext(Properties config, TaskId taskId, File stateDir) {
        Properties configCopy = new Properties();
        configCopy.putAll((Map<?, ?>)config);
        configCopy.putIfAbsent("bootstrap.servers", "dummy-bootstrap-host:0");
        configCopy.putIfAbsent("application.id", "dummy-mock-app-id");
        ClientUtils.QuietStreamsConfig streamsConfig = new ClientUtils.QuietStreamsConfig((Map)configCopy);
        this.taskId = taskId;
        this.config = streamsConfig;
        this.stateDir = stateDir;
        MetricConfig metricConfig = new MetricConfig();
        metricConfig.recordLevel(Sensor.RecordingLevel.DEBUG);
        String threadId = Thread.currentThread().getName();
        this.metrics = new StreamsMetricsImpl(new Metrics(metricConfig), threadId, Time.SYSTEM);
        TaskMetrics.droppedRecordsSensor((String)threadId, (String)taskId.toString(), (StreamsMetricsImpl)this.metrics);
    }

    public String applicationId() {
        return this.config.getString("application.id");
    }

    public TaskId taskId() {
        return this.taskId;
    }

    public Map<String, Object> appConfigs() {
        HashMap<String, Object> combined = new HashMap<String, Object>();
        combined.putAll(this.config.originals());
        combined.putAll(this.config.values());
        return combined;
    }

    public Map<String, Object> appConfigsWithPrefix(String prefix) {
        return this.config.originalsWithPrefix(prefix);
    }

    public long currentSystemTimeMs() {
        if (this.currentSystemTimeMs == null) {
            throw new IllegalStateException("System time must be set before use via setCurrentSystemTimeMs().");
        }
        return this.currentSystemTimeMs;
    }

    public long currentStreamTimeMs() {
        if (this.currentStreamTimeMs == null) {
            throw new IllegalStateException("Stream time must be set before use via setCurrentStreamTimeMs().");
        }
        return this.currentStreamTimeMs;
    }

    public Serde<?> keySerde() {
        return this.config.defaultKeySerde();
    }

    public Serde<?> valueSerde() {
        return this.config.defaultValueSerde();
    }

    public File stateDir() {
        return this.stateDir;
    }

    public StreamsMetrics metrics() {
        return this.metrics;
    }

    public void setRecordMetadata(String topic, int partition, long offset, Headers headers, long timestamp) {
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
        this.headers = headers;
        this.recordTimestamp = timestamp;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setPartition(int partition) {
        this.partition = partition;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    public void setRecordTimestamp(long recordTimestamp) {
        this.recordTimestamp = recordTimestamp;
    }

    public void setCurrentSystemTimeMs(long currentSystemTimeMs) {
        this.currentSystemTimeMs = currentSystemTimeMs;
    }

    public void setCurrentStreamTimeMs(long currentStreamTimeMs) {
        this.currentStreamTimeMs = currentStreamTimeMs;
    }

    public String topic() {
        if (this.topic == null) {
            throw new IllegalStateException("Topic must be set before use via setRecordMetadata() or setTopic().");
        }
        return this.topic;
    }

    public int partition() {
        if (this.partition == null) {
            throw new IllegalStateException("Partition must be set before use via setRecordMetadata() or setPartition().");
        }
        return this.partition;
    }

    public long offset() {
        if (this.offset == null) {
            throw new IllegalStateException("Offset must be set before use via setRecordMetadata() or setOffset().");
        }
        return this.offset;
    }

    public Headers headers() {
        return this.headers;
    }

    public long timestamp() {
        if (this.recordTimestamp == null) {
            throw new IllegalStateException("Timestamp must be set before use via setRecordMetadata() or setRecordTimestamp().");
        }
        return this.recordTimestamp;
    }

    public void register(StateStore store, StateRestoreCallback stateRestoreCallbackIsIgnoredInMock) {
        this.stateStores.put(store.name(), store);
    }

    public <S extends StateStore> S getStateStore(String name) {
        return (S)this.stateStores.get(name);
    }

    public Cancellable schedule(Duration interval, PunctuationType type, Punctuator callback) throws IllegalArgumentException {
        long intervalMs = ApiUtils.validateMillisecondDuration((Duration)interval, (String)"interval");
        if (intervalMs < 1L) {
            throw new IllegalArgumentException("The minimum supported scheduling interval is 1 millisecond.");
        }
        CapturedPunctuator capturedPunctuator = new CapturedPunctuator(intervalMs, type, callback);
        this.punctuators.add(capturedPunctuator);
        return capturedPunctuator::cancel;
    }

    public Cancellable schedule(Instant startTime, Duration interval, PunctuationType type, Punctuator callback) throws IllegalArgumentException {
        long intervalMs = ApiUtils.validateMillisecondDuration((Duration)interval, (String)"interval");
        if (intervalMs < 1L) {
            throw new IllegalArgumentException("The minimum supported scheduling interval is 1 millisecond.");
        }
        if (startTime.isBefore(Instant.EPOCH)) {
            throw new IllegalArgumentException("The minimum supported start time is Instant.EPOCH.");
        }
        CapturedPunctuator capturedPunctuator = new CapturedPunctuator(startTime, intervalMs, type, callback);
        this.punctuators.add(capturedPunctuator);
        return capturedPunctuator::cancel;
    }

    public List<CapturedPunctuator> scheduledPunctuators() {
        return new LinkedList<CapturedPunctuator>(this.punctuators);
    }

    public <K, V> void forward(K key, V value) {
        this.forward(key, value, To.all());
    }

    public <K, V> void forward(K key, V value, To to) {
        this.capturedForwards.add(new CapturedForward(new KeyValue(key, value), to.timestamp == -1L ? to.withTimestamp(this.recordTimestamp == null ? -1L : this.recordTimestamp) : to, this.headers));
    }

    public List<CapturedForward> forwarded() {
        return new LinkedList<CapturedForward>(this.capturedForwards);
    }

    public List<CapturedForward> forwarded(String childName) {
        LinkedList<CapturedForward> result = new LinkedList<CapturedForward>();
        for (CapturedForward capture : this.capturedForwards) {
            if (capture.childName() != null && !capture.childName().equals(childName)) continue;
            result.add(capture);
        }
        return result;
    }

    public void resetForwards() {
        this.capturedForwards.clear();
    }

    public void commit() {
        this.committed = true;
    }

    public boolean committed() {
        return this.committed;
    }

    public void resetCommit() {
        this.committed = false;
    }

    public RecordCollector recordCollector() {
        throw new UnsupportedOperationException("MockProcessorContext does not provide record collection. For processor unit tests, use an in-memory state store with change-logging disabled. Alternatively, use the TopologyTestDriver for testing processor/store/topology integration.");
    }

    public static class CapturedPunctuator {
        private final Instant startTime;
        private final long intervalMs;
        private final PunctuationType type;
        private final Punctuator punctuator;
        private boolean cancelled = false;

        private CapturedPunctuator(long intervalMs, PunctuationType type, Punctuator punctuator) {
            this.startTime = null;
            this.intervalMs = intervalMs;
            this.type = type;
            this.punctuator = punctuator;
        }

        private CapturedPunctuator(Instant startTime, long intervalMs, PunctuationType type, Punctuator punctuator) {
            this.startTime = startTime;
            this.intervalMs = intervalMs;
            this.type = type;
            this.punctuator = punctuator;
        }

        public Instant getStartTime() {
            return this.startTime;
        }

        public long getIntervalMs() {
            return this.intervalMs;
        }

        public PunctuationType getType() {
            return this.type;
        }

        public Punctuator getPunctuator() {
            return this.punctuator;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public boolean cancelled() {
            return this.cancelled;
        }
    }

    public static class CapturedForward {
        private final String childName;
        private final long timestamp;
        private final Headers headers;
        private final KeyValue<?, ?> keyValue;

        private CapturedForward(KeyValue<?, ?> keyValue, To to, Headers headers) {
            if (keyValue == null) {
                throw new IllegalArgumentException();
            }
            this.childName = to.childName;
            this.timestamp = to.timestamp;
            this.keyValue = keyValue;
            this.headers = headers;
        }

        public String childName() {
            return this.childName;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public KeyValue keyValue() {
            return this.keyValue;
        }

        public String toString() {
            return "CapturedForward{childName='" + this.childName + "', timestamp=" + this.timestamp + ", keyValue=" + String.valueOf(this.keyValue) + "}";
        }

        public Headers headers() {
            return this.headers;
        }
    }
}

