/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.fetch;

import java.util.Objects;

public enum RecordState {
    AVAILABLE(0),
    ACQUIRED(1),
    ACKNOWLEDGED(2),
    ARCHIVED(4);

    public final byte id;

    private RecordState(byte id) {
        this.id = id;
    }

    public RecordState validateTransition(RecordState newState) throws IllegalStateException {
        Objects.requireNonNull(newState, "newState cannot be null");
        if (this == newState) {
            throw new IllegalStateException("The state transition is invalid as the new state is the same as the current state");
        }
        if (this == ACKNOWLEDGED || this == ARCHIVED) {
            throw new IllegalStateException("The state transition is invalid from the current state: " + String.valueOf((Object)this));
        }
        if (this == AVAILABLE && newState != ACQUIRED) {
            throw new IllegalStateException("The state can only be transitioned to ACQUIRED from AVAILABLE");
        }
        return newState;
    }

    public static RecordState forId(byte id) {
        return switch (id) {
            case 0 -> AVAILABLE;
            case 1 -> ACQUIRED;
            case 2 -> ACKNOWLEDGED;
            case 4 -> ARCHIVED;
            default -> throw new IllegalArgumentException("Unknown record state id: " + id);
        };
    }

    public byte id() {
        return this.id;
    }
}

