/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.transaction;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.transaction.ProducerIdManager;
import org.apache.kafka.server.common.ControllerRequestCompletionHandler;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import org.apache.kafka.server.common.ProducerIdsBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RPCProducerIdManager
implements ProducerIdManager {
    static final int RETRY_BACKOFF_MS = 50;
    private static final double PID_PREFETCH_THRESHOLD = 0.9;
    private static final int ITERATION_LIMIT = 3;
    private static final long NO_RETRY = -1L;
    private static final Logger log = LoggerFactory.getLogger(RPCProducerIdManager.class);
    private final String logPrefix;
    private final int brokerId;
    final Time time;
    private final Supplier<Long> brokerEpochSupplier;
    private final NodeToControllerChannelManager controllerChannel;
    final AtomicReference<ProducerIdsBlock> nextProducerIdBlock = new AtomicReference<Object>(null);
    private final AtomicReference<ProducerIdsBlock> currentProducerIdBlock = new AtomicReference<ProducerIdsBlock>(ProducerIdsBlock.EMPTY);
    private final AtomicBoolean requestInFlight = new AtomicBoolean(false);
    private final AtomicLong backoffDeadlineMs = new AtomicLong(-1L);

    public RPCProducerIdManager(int brokerId, Time time, Supplier<Long> brokerEpochSupplier, NodeToControllerChannelManager controllerChannel) {
        this.brokerId = brokerId;
        this.time = time;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.controllerChannel = controllerChannel;
        this.logPrefix = "[RPC ProducerId Manager " + brokerId + "]: ";
    }

    @Override
    public long generateProducerId() {
        for (int iteration = 0; iteration <= 3; ++iteration) {
            Optional claimNextId = this.currentProducerIdBlock.get().claimNextId();
            if (claimNextId.isPresent()) {
                long prefetchTarget;
                long nextProducerId = (Long)claimNextId.get();
                if (nextProducerId == (prefetchTarget = this.currentProducerIdBlock.get().firstProducerId() + (long)((double)this.currentProducerIdBlock.get().size() * 0.9))) {
                    this.maybeRequestNextBlock();
                }
                return nextProducerId;
            }
            ProducerIdsBlock block = this.nextProducerIdBlock.getAndSet(null);
            if (block == null) {
                this.maybeRequestNextBlock();
                throw Errors.COORDINATOR_LOAD_IN_PROGRESS.exception("Producer ID block is full. Waiting for next block");
            }
            this.currentProducerIdBlock.set(block);
            this.requestInFlight.set(false);
        }
        throw Errors.COORDINATOR_LOAD_IN_PROGRESS.exception("Producer ID block is full. Waiting for next block");
    }

    private void maybeRequestNextBlock() {
        long retryTimestamp = this.backoffDeadlineMs.get();
        if ((retryTimestamp == -1L || this.time.milliseconds() >= retryTimestamp) && this.nextProducerIdBlock.get() == null && this.requestInFlight.compareAndSet(false, true)) {
            this.sendRequest();
            this.backoffDeadlineMs.set(-1L);
        }
    }

    protected void sendRequest() {
        AllocateProducerIdsRequestData message = new AllocateProducerIdsRequestData().setBrokerEpoch(this.brokerEpochSupplier.get().longValue()).setBrokerId(this.brokerId);
        AllocateProducerIdsRequest.Builder request = new AllocateProducerIdsRequest.Builder(message);
        log.debug("{} Requesting next Producer ID block", (Object)this.logPrefix);
        this.controllerChannel.sendRequest((AbstractRequest.Builder)request, new ControllerRequestCompletionHandler(){

            public void onComplete(ClientResponse response) {
                RPCProducerIdManager.this.handleAllocateProducerIdsResponse(response);
            }

            public void onTimeout() {
                log.warn("{} Timed out when requesting AllocateProducerIds from the controller.", (Object)RPCProducerIdManager.this.logPrefix);
                RPCProducerIdManager.this.requestInFlight.set(false);
            }
        });
    }

    private void handleUnsuccessfulResponse() {
        this.backoffDeadlineMs.set(this.time.milliseconds() + 50L);
        this.requestInFlight.set(false);
    }

    protected void handleAllocateProducerIdsResponse(ClientResponse clientResponse) {
        if (clientResponse.authenticationException() != null) {
            log.error("{} Unable to allocate producer id because of an authentication exception", (Object)this.logPrefix, (Object)clientResponse.authenticationException());
            this.handleUnsuccessfulResponse();
            return;
        }
        if (clientResponse.versionMismatch() != null) {
            log.error("{} Unable to allocate producer id because of a version mismatch exception", (Object)this.logPrefix, (Object)clientResponse.versionMismatch());
            this.handleUnsuccessfulResponse();
            return;
        }
        if (!clientResponse.hasResponse()) {
            log.error("{} Unable to allocate producer id because of empty response from controller", (Object)this.logPrefix);
            this.handleUnsuccessfulResponse();
            return;
        }
        AllocateProducerIdsResponse response = (AllocateProducerIdsResponse)clientResponse.responseBody();
        AllocateProducerIdsResponseData data = response.data();
        boolean successfulResponse = false;
        Errors errors = Errors.forCode((short)data.errorCode());
        switch (errors) {
            case NONE: {
                log.debug("{} Got next producer ID block from controller {}", (Object)this.logPrefix, (Object)data);
                successfulResponse = this.sanityCheckResponse(data);
                break;
            }
            case STALE_BROKER_EPOCH: {
                log.warn("{} Our broker currentBlockCount was stale, trying again.", (Object)this.logPrefix);
                break;
            }
            case BROKER_ID_NOT_REGISTERED: {
                log.warn("{} Our broker ID is not yet known by the controller, trying again.", (Object)this.logPrefix);
                break;
            }
            default: {
                log.error("{} Received error code {} from the controller.", (Object)this.logPrefix, (Object)errors);
            }
        }
        if (!successfulResponse) {
            this.handleUnsuccessfulResponse();
        }
    }

    private boolean sanityCheckResponse(AllocateProducerIdsResponseData data) {
        if (data.producerIdStart() < this.currentProducerIdBlock.get().lastProducerId()) {
            log.error("{} Producer ID block is not monotonic with current block: current={} response={}", new Object[]{this.logPrefix, this.currentProducerIdBlock.get(), data});
        } else if (data.producerIdStart() < 0L || data.producerIdLen() < 0 || data.producerIdStart() > Long.MAX_VALUE - (long)data.producerIdLen()) {
            log.error("{} Producer ID block includes invalid ID range: {}", (Object)this.logPrefix, (Object)data);
        } else {
            this.nextProducerIdBlock.set(new ProducerIdsBlock(this.brokerId, data.producerIdStart(), data.producerIdLen()));
            return true;
        }
        return false;
    }
}

