/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import kafka.network.ConnectionQuotas;
import kafka.server.QuotaFactory;
import kafka.server.metadata.ClientIdEntity;
import kafka.server.metadata.ClientQuotaMetadataManager$;
import kafka.server.metadata.DefaultClientIdEntity$;
import kafka.server.metadata.DefaultIpEntity$;
import kafka.server.metadata.DefaultUserDefaultClientIdEntity$;
import kafka.server.metadata.DefaultUserEntity$;
import kafka.server.metadata.DefaultUserExplicitClientIdEntity;
import kafka.server.metadata.ExplicitUserDefaultClientIdEntity;
import kafka.server.metadata.ExplicitUserExplicitClientIdEntity;
import kafka.server.metadata.IpEntity;
import kafka.server.metadata.QuotaEntity;
import kafka.server.metadata.UserEntity;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.image.ClientQuotaDelta;
import org.apache.kafka.image.ClientQuotasDelta;
import org.apache.kafka.server.quota.ClientQuotaEntity;
import org.apache.kafka.server.quota.ClientQuotaManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005-d\u0001\u0002\b\u0010\u0001YA\u0011\u0002\u000f\u0001\u0003\u0006\u0004%\taD\u001d\t\u0011!\u0003!\u0011!Q\u0001\niB\u0011\"\u0013\u0001\u0003\u0006\u0004%\ta\u0004&\t\u0011E\u0003!\u0011!Q\u0001\n-CQA\u0015\u0001\u0005\u0002MCQ\u0001\u0017\u0001\u0005\u0002eCQA\u0019\u0001\u0005\n\rDaa\u001d\u0001\u0005\u0002=!\b\"B>\u0001\t\u0013axaBA\u0012\u001f!\u0005\u0011Q\u0005\u0004\u0007\u001d=A\t!a\n\t\rI[A\u0011AA\u0018\u0011\u001d\t\td\u0003C\u0001\u0003g\u0011!d\u00117jK:$\u0018+^8uC6+G/\u00193bi\u0006l\u0015M\\1hKJT!\u0001E\t\u0002\u00115,G/\u00193bi\u0006T!AE\n\u0002\rM,'O^3s\u0015\u0005!\u0012!B6bM.\f7\u0001A\n\u0005\u0001]y\"\u0007\u0005\u0002\u0019;5\t\u0011D\u0003\u0002\u001b7\u0005!A.\u00198h\u0015\u0005a\u0012\u0001\u00026bm\u0006L!AH\r\u0003\r=\u0013'.Z2u!\r\u0001SeJ\u0007\u0002C)\u0011!eI\u0001\tMVt7\r^5p]*\u0011AeG\u0001\u0005kRLG.\u0003\u0002'C\tA1i\u001c8tk6,'\u000f\u0005\u0002)a5\t\u0011F\u0003\u0002+W\u0005)\u0011.\\1hK*\u0011A\u0003\f\u0006\u0003[9\na!\u00199bG\",'\"A\u0018\u0002\u0007=\u0014x-\u0003\u00022S\t\t2\t\\5f]R\fVo\u001c;bg\u0012+G\u000e^1\u0011\u0005M2T\"\u0001\u001b\u000b\u0005U\u001a\u0012!B;uS2\u001c\u0018BA\u001c5\u0005\u001daunZ4j]\u001e\fQ\"];pi\u0006l\u0015M\\1hKJ\u001cX#\u0001\u001e\u0011\u0005m*eB\u0001\u001fD\u001d\ti$I\u0004\u0002?\u00036\tqH\u0003\u0002A+\u00051AH]8pizJ\u0011\u0001F\u0005\u0003%MI!\u0001R\t\u0002\u0019E+x\u000e^1GC\u000e$xN]=\n\u0005\u0019;%!D)v_R\fW*\u00198bO\u0016\u00148O\u0003\u0002E#\u0005q\u0011/^8uC6\u000bg.Y4feN\u0004\u0013\u0001E2p]:,7\r^5p]F+x\u000e^1t+\u0005Y\u0005C\u0001'P\u001b\u0005i%B\u0001(\u0014\u0003\u001dqW\r^<pe.L!\u0001U'\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\u0018!E2p]:,7\r^5p]F+x\u000e^1tA\u00051A(\u001b8jiz\"2\u0001\u0016,X!\t)\u0006!D\u0001\u0010\u0011\u0015AT\u00011\u0001;\u0011\u0015IU\u00011\u0001L\u0003\u0019\t7mY3qiR\u0011!\f\u0019\t\u00037zk\u0011\u0001\u0018\u0006\u0002;\u0006)1oY1mC&\u0011q\f\u0018\u0002\u0005+:LG\u000fC\u0003b\r\u0001\u0007q%A\u0006rk>$\u0018m\u001d#fYR\f\u0017AB;qI\u0006$X\rF\u0002[I:DQ!Z\u0004A\u0002\u0019\fa!\u001a8uSRL\bCA4m\u001b\u0005A'BA5k\u0003\u0015\tXo\u001c;b\u0015\tY7&\u0001\u0004d_6lwN\\\u0005\u0003[\"\u0014\u0011c\u00117jK:$\u0018+^8uC\u0016sG/\u001b;z\u0011\u0015yw\u00011\u0001q\u0003)\tXo\u001c;b\t\u0016dG/\u0019\t\u0003QEL!A]\u0015\u0003!\rc\u0017.\u001a8u#V|G/\u0019#fYR\f\u0017!\u00045b]\u0012dW-\u00139Rk>$\u0018\rF\u0002[kjDQA\u001e\u0005A\u0002]\f\u0001\"\u001b9F]RLG/\u001f\t\u0003+bL!!_\b\u0003\u0017E+x\u000e^1F]RLG/\u001f\u0005\u0006_\"\u0001\r\u0001]\u0001\u001cQ\u0006tG\r\\3Vg\u0016\u00148\t\\5f]R\fVo\u001c;b\u0007\"\fgnZ3\u0015\u000bikx0a\u0005\t\u000byL\u0001\u0019A<\u0002\u0017E,x\u000e^1F]RLG/\u001f\u0005\b\u0003\u0003I\u0001\u0019AA\u0002\u0003\rYW-\u001f\t\u0005\u0003\u000b\tiA\u0004\u0003\u0002\b\u0005%\u0001C\u0001 ]\u0013\r\tY\u0001X\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0011\u0011\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-A\fC\u0004\u0002\u0016%\u0001\r!a\u0006\u0002\u00119,wOV1mk\u0016\u0004RaWA\r\u0003;I1!a\u0007]\u0005\u0019y\u0005\u000f^5p]B\u00191,a\b\n\u0007\u0005\u0005BL\u0001\u0004E_V\u0014G.Z\u0001\u001b\u00072LWM\u001c;Rk>$\u0018-T3uC\u0012\fG/Y'b]\u0006<WM\u001d\t\u0003+.\u00192aCA\u0015!\rY\u00161F\u0005\u0004\u0003[a&AB!osJ+g\r\u0006\u0002\u0002&\u0005YBO]1og\u001a,'\u000fV8DY&,g\u000e^)v_R\fWI\u001c;jif$B!!\u000e\u0002jA91,a\u000e\u0002<\u0005m\u0012bAA\u001d9\n1A+\u001e9mKJ\u0002b!!\u0010\u0002@\u0005\rS\"A\u0012\n\u0007\u0005\u00053E\u0001\u0005PaRLwN\\1m!\u0011\t)%a\u0019\u000f\t\u0005\u001d\u0013Q\f\b\u0005\u0003\u0013\nIF\u0004\u0003\u0002L\u0005]c\u0002BA'\u0003+rA!a\u0014\u0002T9\u0019a(!\u0015\n\u0003=J!!\f\u0018\n\u0005Qa\u0013B\u0001\n,\u0013\rI\u00171\f\u0006\u0003%-JA!a\u0018\u0002b\u0005\t2\t\\5f]R\fVo\u001c;b\u000b:$\u0018\u000e^=\u000b\u0007%\fY&\u0003\u0003\u0002f\u0005\u001d$\u0001D\"p]\u001aLw-\u00128uSRL(\u0002BA0\u0003CBQA`\u0007A\u0002]\u0004")
public class ClientQuotaMetadataManager
implements Consumer<ClientQuotasDelta>,
Logging {
    private final QuotaFactory.QuotaManagers quotaManagers;
    private final ConnectionQuotas connectionQuotas;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Tuple2<Optional<ClientQuotaEntity.ConfigEntity>, Optional<ClientQuotaEntity.ConfigEntity>> transferToClientQuotaEntity(QuotaEntity quotaEntity) {
        return ClientQuotaMetadataManager$.MODULE$.transferToClientQuotaEntity(quotaEntity);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public Consumer<ClientQuotasDelta> andThen(Consumer<? super ClientQuotasDelta> x$1) {
        return Consumer.super.andThen(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    @Override
    public void accept(ClientQuotasDelta quotasDelta) {
        quotasDelta.changes().forEach((key, value) -> this.update((ClientQuotaEntity)key, (ClientQuotaDelta)value));
    }

    private void update(ClientQuotaEntity entity, ClientQuotaDelta quotaDelta) {
        if (entity.entries().containsKey("ip")) {
            Product product;
            Option option = Option$.MODULE$.apply(entity.entries().get("ip"));
            if (option instanceof Some) {
                String ip = (String)((Some)option).value();
                product = new IpEntity(ip);
            } else if (None$.MODULE$.equals(option)) {
                product = DefaultIpEntity$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            Product ipEntity = product;
            this.handleIpQuota((QuotaEntity)ipEntity, quotaDelta);
            return;
        }
        if (entity.entries().containsKey("user") || entity.entries().containsKey("client-id")) {
            String userVal = (String)entity.entries().get("user");
            String clientIdVal = (String)entity.entries().get("client-id");
            Product userClientEntity = entity.entries().containsKey("user") && entity.entries().containsKey("client-id") ? (userVal == null && clientIdVal == null ? DefaultUserDefaultClientIdEntity$.MODULE$ : (userVal == null ? new DefaultUserExplicitClientIdEntity(clientIdVal) : (clientIdVal == null ? new ExplicitUserDefaultClientIdEntity(userVal) : new ExplicitUserExplicitClientIdEntity(userVal, clientIdVal)))) : (entity.entries().containsKey("user") ? (userVal == null ? DefaultUserEntity$.MODULE$ : new UserEntity(userVal)) : (clientIdVal == null ? DefaultClientIdEntity$.MODULE$ : new ClientIdEntity(clientIdVal)));
            quotaDelta.changes().forEach((key, value) -> this.handleUserClientQuotaChange((QuotaEntity)userClientEntity, (String)key, (Option<Object>)OptionConverters.RichOptionalDouble$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(value))));
            return;
        }
        this.warn((Function0<String>)(Function0 & Serializable)() -> "Ignoring unsupported quota entity " + entity + ".");
    }

    public void handleIpQuota(QuotaEntity ipEntity, ClientQuotaDelta quotaDelta) {
        None$ none$;
        if (ipEntity instanceof IpEntity) {
            String ip = ((IpEntity)ipEntity).ip();
            try {
                none$ = new Some((Object)InetAddress.getByName(ip));
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException("Unable to resolve address " + ip);
            }
        } else if (DefaultIpEntity$.MODULE$.equals(ipEntity)) {
            none$ = None$.MODULE$;
        } else {
            throw new IllegalStateException("Should only handle IP quota entities here");
        }
        None$ inetAddress = none$;
        quotaDelta.changes().forEach((arg_0, arg_1) -> ClientQuotaMetadataManager.$anonfun$handleIpQuota$1(this, ipEntity, (Option)inetAddress, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleUserClientQuotaChange(QuotaEntity quotaEntity, String key, Option<Object> newValue) {
        ClientQuotaManager clientQuotaManager;
        block9: {
            switch (key == null ? 0 : key.hashCode()) {
                case -1805480786: {
                    if (!"consumer_byte_rate".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().fetch();
                    break block9;
                }
                case -965904822: {
                    if (!"request_percentage".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().request();
                    break block9;
                }
                case -832502454: {
                    if (!"producer_byte_rate".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().produce();
                    break block9;
                }
                case -748852909: {
                    if (!"controller_mutation_rate".equals(key)) break;
                    clientQuotaManager = this.quotaManagers().controllerMutation();
                    break block9;
                }
            }
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Ignoring unexpected quota key " + key + " for entity " + quotaEntity);
            return;
        }
        ClientQuotaManager manager = clientQuotaManager;
        Tuple2<Optional<ClientQuotaEntity.ConfigEntity>, Optional<ClientQuotaEntity.ConfigEntity>> tuple2 = ClientQuotaMetadataManager$.MODULE$.transferToClientQuotaEntity(quotaEntity);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Optional userEntity = (Optional)tuple2._1();
        Optional clientEntity = (Optional)tuple2._2();
        Optional quotaValue = (Optional)newValue.map((Function1 & Serializable)v -> ClientQuotaMetadataManager.$anonfun$handleUserClientQuotaChange$2(BoxesRunTime.unboxToDouble((Object)v))).getOrElse((Function0 & Serializable)() -> Optional.empty());
        try {
            void var7_7;
            void var6_6;
            manager.updateQuota((Optional)var6_6, (Optional)var7_7, quotaValue);
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to update user-client quota " + quotaEntity, (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$handleIpQuota$1(ClientQuotaMetadataManager $this, QuotaEntity ipEntity$1, Option inetAddress$1, String key, OptionalDouble value) {
        if (!key.equals("connection_creation_rate")) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> "Ignoring unexpected quota key " + key + " for entity " + ipEntity$1);
            return;
        }
        try {
            $this.connectionQuotas().updateIpConnectionRateQuota((Option<InetAddress>)inetAddress$1, (Option<Object>)OptionConverters.RichOptionalDouble$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptionalDouble(value)).map((Function1)(JFunction1.mcID.sp & Serializable)x$1 -> (int)x$1));
            return;
        }
        catch (Throwable t) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to update IP quota " + ipEntity$1, (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
    }

    public static final /* synthetic */ Optional $anonfun$handleUserClientQuotaChange$2(double v) {
        return Optional.of(new Quota(v, true));
    }

    public ClientQuotaMetadataManager(QuotaFactory.QuotaManagers quotaManagers, ConnectionQuotas connectionQuotas) {
        this.quotaManagers = quotaManagers;
        this.connectionQuotas = connectionQuotas;
    }
}

