/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.DynamicConfigPublisher;
import kafka.server.metadata.DynamicTopicClusterQuotaPublisher;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.share.SharePartitionManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.config.BrokerReconfigurable;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetadataDelta;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetadataImage;
import org.apache.kafka.coordinator.common.runtime.KRaftCoordinatorMetadataDelta;
import org.apache.kafka.coordinator.common.runtime.KRaftCoordinatorMetadataImage;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.coordinator.share.ShareCoordinator;
import org.apache.kafka.coordinator.transaction.TransactionLogConfig;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.publisher.AclPublisher;
import org.apache.kafka.metadata.publisher.DelegationTokenPublisher;
import org.apache.kafka.metadata.publisher.DynamicClientQuotaPublisher;
import org.apache.kafka.metadata.publisher.ScramPublisher;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.common.RequestLocal;
import org.apache.kafka.server.common.ShareVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.storage.internals.log.LogManager;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\tUt!B\u0015+\u0011\u0003\td!B\u001a+\u0011\u0003!\u0004\"B!\u0002\t\u0003\u0011\u0005\"B\"\u0002\t\u0003!e\u0001B\u001a+\u0001)D\u0001\"\u001f\u0003\u0003\u0002\u0003\u0006IA\u001f\u0005\t}\u0012\u0011\t\u0011)A\u0005\u007f\"Q\u0011Q\u0001\u0003\u0003\u0002\u0003\u0006I!a\u0002\t\u0015\u0005MAA!A!\u0002\u0013\t)\u0002\u0003\u0006\u0002\u001c\u0011\u0011\t\u0011)A\u0005\u0003;A!\"!\f\u0005\u0005\u0003\u0005\u000b\u0011BA\u0018\u0011)\ti\u0004\u0002B\u0001B\u0003%\u0011q\b\u0005\u000b\u0003\u0017\"!\u0011!Q\u0001\n\u00055\u0003BCA,\t\t\u0005\r\u0011\"\u0001\u0002Z!Q\u0011\u0011\r\u0003\u0003\u0002\u0004%\t!a\u0019\t\u0015\u0005=DA!A!B\u0013\tY\u0006\u0003\u0006\u0002r\u0011\u0011\t\u0011)A\u0005\u0003gB!\"a \u0005\u0005\u0003\u0005\u000b\u0011BAA\u0011)\t9\t\u0002B\u0001B\u0003%\u0011\u0011\u0012\u0005\u000b\u0003\u001f#!\u0011!Q\u0001\n\u0005E\u0005BCAL\t\t\u0005\t\u0015!\u0003\u0002\u001a\"Q\u0011q\u0014\u0003\u0003\u0002\u0003\u0006I!!)\t\u0015\u0005=FA!A!\u0002\u0013\t\t\u000b\u0003\u0004B\t\u0011\u0005\u0011\u0011\u0017\u0005\n\u0003+$!\u0019!C\u0001\u0003/D\u0001\"a8\u0005A\u0003%\u0011\u0011\u001c\u0005\n\u0003C$\u0001\u0019!C\u0001\u0003GD\u0011\"a;\u0005\u0001\u0004%\t!!<\t\u0011\u0005EH\u0001)Q\u0005\u0003KD\u0011\"a=\u0005\u0005\u0004%\t!!>\t\u0011\t5A\u0001)A\u0005\u0003oD\u0011Ba\u0004\u0005\u0001\u0004%IA!\u0005\t\u0013\teA\u00011A\u0005\n\tm\u0001\u0002\u0003B\u0010\t\u0001\u0006KAa\u0005\t\u000f\t\u0005B\u0001\"\u0011\u0003$!9!Q\u0005\u0003\u0005B\t\u001d\u0002b\u0002B\u001f\t\u0011%!q\b\u0005\b\u0005\u001f\"A\u0011\u0001B)\u0011\u001d\u0011I\u0007\u0002C\u0005\u0005WBqAa\u001c\u0005\t\u0013\u0011\t\bC\u0004\u0003t\u0011!\tE!\u001d\u0002/\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u0014(BA\u0016-\u0003!iW\r^1eCR\f'BA\u0017/\u0003\u0019\u0019XM\u001d<fe*\tq&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005I\nQ\"\u0001\u0016\u0003/\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u00148cA\u00016wA\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t1\u0011I\\=SK\u001a\u0004\"\u0001P \u000e\u0003uR!A\u0010\u0018\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0001k$a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\nQbZ3u)>\u0004\u0018n\u0019#fYR\fG\u0003B#TA\u0016\u00042A\u000e$I\u0013\t9uG\u0001\u0004PaRLwN\u001c\t\u0003\u0013Fk\u0011A\u0013\u0006\u0003\u00172\u000bQ![7bO\u0016T!aL'\u000b\u00059{\u0015AB1qC\u000eDWMC\u0001Q\u0003\ry'oZ\u0005\u0003%*\u0013!\u0002V8qS\u000e$U\r\u001c;b\u0011\u0015!6\u00011\u0001V\u0003%!x\u000e]5d\u001d\u0006lW\r\u0005\u0002W;:\u0011qk\u0017\t\u00031^j\u0011!\u0017\u0006\u00035B\na\u0001\u0010:p_Rt\u0014B\u0001/8\u0003\u0019\u0001&/\u001a3fM&\u0011al\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005q;\u0004\"B1\u0004\u0001\u0004\u0011\u0017\u0001\u00038fo&k\u0017mZ3\u0011\u0005%\u001b\u0017B\u00013K\u00055iU\r^1eCR\f\u0017*\\1hK\")am\u0001a\u0001O\u0006)A-\u001a7uCB\u0011\u0011\n[\u0005\u0003S*\u0013Q\"T3uC\u0012\fG/\u0019#fYR\f7\u0003\u0002\u0003lgn\u0002\"\u0001\\9\u000e\u00035T!A\\8\u0002\t1\fgn\u001a\u0006\u0002a\u0006!!.\u0019<b\u0013\t\u0011XN\u0001\u0004PE*,7\r\u001e\t\u0003i^l\u0011!\u001e\u0006\u0003m*\u000b\u0011\u0002];cY&\u001c\b.\u001a:\n\u0005a,(!E'fi\u0006$\u0017\r^1Qk\nd\u0017n\u001d5fe\u000611m\u001c8gS\u001e\u0004\"a\u001f?\u000e\u00031J!! \u0017\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u0007I\n\t!C\u0002\u0002\u0004)\u0012!c\u0013*bMRlU\r^1eCR\f7)Y2iK\u0006QAn\\4NC:\fw-\u001a:\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004/\u0003\rawnZ\u0005\u0005\u0003#\tYA\u0001\u0006M_\u001el\u0015M\\1hKJ\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000fE\u0002|\u0003/I1!!\u0007-\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\f\u0001c\u001a:pkB\u001cun\u001c:eS:\fGo\u001c:\u0011\t\u0005}\u0011\u0011F\u0007\u0003\u0003CQA!a\t\u0002&\u0005)qM]8va*\u0019\u0011q\u0005'\u0002\u0017\r|wN\u001d3j]\u0006$xN]\u0005\u0005\u0003W\t\tC\u0001\tHe>,\boQ8pe\u0012Lg.\u0019;pe\u0006qA\u000f\u001f8D_>\u0014H-\u001b8bi>\u0014\b\u0003BA\u0019\u0003si!!a\r\u000b\t\u0005U\u0012qG\u0001\fiJ\fgn]1di&|gNC\u0002\u0002(9JA!a\u000f\u00024\t1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'/\u0001\ttQ\u0006\u0014XmQ8pe\u0012Lg.\u0019;peB!\u0011\u0011IA$\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u0015\u0012!B:iCJ,\u0017\u0002BA%\u0003\u0007\u0012\u0001c\u00155be\u0016\u001cun\u001c:eS:\fGo\u001c:\u0002+MD\u0017M]3QCJ$\u0018\u000e^5p]6\u000bg.Y4feB!\u0011qJA*\u001b\t\t\tFC\u0002\u0002F1JA!!\u0016\u0002R\t)2\u000b[1sKB\u000b'\u000f^5uS>tW*\u00198bO\u0016\u0014\u0018A\u00063z]\u0006l\u0017nY\"p]\u001aLw\rU;cY&\u001c\b.\u001a:\u0016\u0005\u0005m\u0003c\u0001\u001a\u0002^%\u0019\u0011q\f\u0016\u0003-\u0011Kh.Y7jG\u000e{gNZ5h!V\u0014G.[:iKJ\f!\u0004Z=oC6L7mQ8oM&<\u0007+\u001e2mSNDWM]0%KF$B!!\u001a\u0002lA\u0019a'a\u001a\n\u0007\u0005%tG\u0001\u0003V]&$\b\"CA7\u001d\u0005\u0005\t\u0019AA.\u0003\rAH%M\u0001\u0018Ift\u0017-\\5d\u0007>tg-[4Qk\nd\u0017n\u001d5fe\u0002\n1\u0004Z=oC6L7m\u00117jK:$\u0018+^8uCB+(\r\\5tQ\u0016\u0014\b\u0003BA;\u0003wj!!a\u001e\u000b\u0007Y\fIH\u0003\u0002,\u0019&!\u0011QPA<\u0005m!\u0015P\\1nS\u000e\u001cE.[3oiF+x\u000e^1Qk\nd\u0017n\u001d5fe\u0006\tC-\u001f8b[&\u001cGk\u001c9jG\u000ecWo\u001d;feF+x\u000e^1Qk\nd\u0017n\u001d5feB\u0019!'a!\n\u0007\u0005\u0015%FA\u0011Es:\fW.[2U_BL7m\u00117vgR,'/U;pi\u0006\u0004VO\u00197jg\",'/\u0001\btGJ\fW\u000eU;cY&\u001c\b.\u001a:\u0011\t\u0005U\u00141R\u0005\u0005\u0003\u001b\u000b9H\u0001\bTGJ\fW\u000eU;cY&\u001c\b.\u001a:\u00021\u0011,G.Z4bi&|g\u000eV8lK:\u0004VO\u00197jg\",'\u000f\u0005\u0003\u0002v\u0005M\u0015\u0002BAK\u0003o\u0012\u0001\u0004R3mK\u001e\fG/[8o)>\\WM\u001c)vE2L7\u000f[3s\u00031\t7\r\u001c)vE2L7\u000f[3s!\u0011\t)(a'\n\t\u0005u\u0015q\u000f\u0002\r\u0003\u000ed\u0007+\u001e2mSNDWM]\u0001\u0012M\u0006$\u0018\r\u001c$bk2$\b*\u00198eY\u0016\u0014\b\u0003BAR\u0003Wk!!!*\u000b\t\u0005\u001d\u0016\u0011V\u0001\u0006M\u0006,H\u000e\u001e\u0006\u0003[1KA!!,\u0002&\naa)Y;mi\"\u000bg\u000e\u001a7fe\u0006qR.\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001b8h\r\u0006,H\u000e\u001e%b]\u0012dWM\u001d\u000b#\u0003g\u000b),a.\u0002:\u0006m\u0016QXA`\u0003\u0003\f\u0019-!2\u0002H\u0006%\u00171ZAg\u0003\u001f\f\t.a5\u0011\u0005I\"\u0001\"B=\u0018\u0001\u0004Q\b\"\u0002@\u0018\u0001\u0004y\bbBA\u0003/\u0001\u0007\u0011q\u0001\u0005\b\u0003'9\u0002\u0019AA\u000b\u0011\u001d\tYb\u0006a\u0001\u0003;Aq!!\f\u0018\u0001\u0004\ty\u0003C\u0004\u0002>]\u0001\r!a\u0010\t\u000f\u0005-s\u00031\u0001\u0002N!9\u0011qK\fA\u0002\u0005m\u0003bBA9/\u0001\u0007\u00111\u000f\u0005\b\u0003\u007f:\u0002\u0019AAA\u0011\u001d\t9i\u0006a\u0001\u0003\u0013Cq!a$\u0018\u0001\u0004\t\t\nC\u0004\u0002\u0018^\u0001\r!!'\t\u000f\u0005}u\u00031\u0001\u0002\"\"9\u0011qV\fA\u0002\u0005\u0005\u0016\u0001\u00032s_.,'/\u00133\u0016\u0005\u0005e\u0007c\u0001\u001c\u0002\\&\u0019\u0011Q\\\u001c\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005iqLZ5sgR\u0004VO\u00197jg\",\"!!:\u0011\u0007Y\n9/C\u0002\u0002j^\u0012qAQ8pY\u0016\fg.A\t`M&\u00148\u000f\u001e)vE2L7\u000f[0%KF$B!!\u001a\u0002p\"I\u0011QN\u000e\u0002\u0002\u0003\u0007\u0011Q]\u0001\u000f?\u001aL'o\u001d;Qk\nd\u0017n\u001d5!\u0003I1\u0017N]:u!V\u0014G.[:i\rV$XO]3\u0016\u0005\u0005]\bCBA}\u0005\u0007\u00119!\u0004\u0002\u0002|*!\u0011Q`A\u0000\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0005\u0003y\u0017\u0001B;uS2LAA!\u0002\u0002|\n\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\u00071\u0014I!C\u0002\u0003\f5\u0014AAV8jI\u0006\u0019b-\u001b:tiB+(\r\\5tQ\u001a+H/\u001e:fA\u0005)b-\u001b8bY&TX\rZ*iCJ,g+\u001a:tS>tWC\u0001B\n!\r1$QC\u0005\u0004\u0005/9$!B*i_J$\u0018!\u00074j]\u0006d\u0017N_3e'\"\f'/\u001a,feNLwN\\0%KF$B!!\u001a\u0003\u001e!I\u0011Q\u000e\u0011\u0002\u0002\u0003\u0007!1C\u0001\u0017M&t\u0017\r\\5{K\u0012\u001c\u0006.\u0019:f-\u0016\u00148/[8oA\u0005!a.Y7f)\u0005)\u0016\u0001E8o\u001b\u0016$\u0018\rZ1uCV\u0003H-\u0019;f)!\t)G!\u000b\u0003,\t5\u0002\"\u00024$\u0001\u00049\u0007\"B1$\u0001\u0004\u0011\u0007b\u0002B\u0018G\u0001\u0007!\u0011G\u0001\t[\u0006t\u0017NZ3tiB!!1\u0007B\u001d\u001b\t\u0011)DC\u0002\u00038)\u000ba\u0001\\8bI\u0016\u0014\u0018\u0002\u0002B\u001e\u0005k\u0011a\u0002T8bI\u0016\u0014X*\u00198jM\u0016\u001cH/A\u0007u_>\u0003H/[8oC2Le\u000e\u001e\u000b\u0005\u0005\u0003\u0012I\u0005\u0005\u0003\u0003D\t\u0015SBAA\u0000\u0013\u0011\u00119%a@\u0003\u0017=\u0003H/[8oC2Le\u000e\u001e\u0005\b\u0005\u0017\"\u0003\u0019\u0001B'\u0003\u0019y\u0007\u000f^5p]B!aGRAm\u0003E)\b\u000fZ1uK\u000e{wN\u001d3j]\u0006$xN\u001d\u000b\r\u0003K\u0012\u0019F!\u0016\u0003X\te#1\r\u0005\u0006\u0017\u0016\u0002\rA\u0019\u0005\u0006M\u0016\u0002\ra\u001a\u0005\u0006)\u0016\u0002\r!\u0016\u0005\b\u00057*\u0003\u0019\u0001B/\u0003!)G.Z2uS>t\u0007#\u0003\u001c\u0003`\u0005e\u0017\u0011\\A3\u0013\r\u0011\tg\u000e\u0002\n\rVt7\r^5p]JBqA!\u001a&\u0001\u0004\u00119'A\u0006sKNLwM\\1uS>t\u0007#\u0003\u001c\u0003`\u0005e'QJA3\u0003IIg.\u001b;jC2L'0Z'b]\u0006<WM]:\u0015\t\u0005\u0015$Q\u000e\u0005\u0006C\u001a\u0002\rAY\u0001!M&t\u0017n\u001d5J]&$\u0018.\u00197ju&twMU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0006\u0002\u0002f\u0005)1\r\\8tK\u0002")
public class BrokerMetadataPublisher
implements MetadataPublisher,
Logging {
    private final KafkaConfig config;
    private final KRaftMetadataCache metadataCache;
    private final kafka.log.LogManager logManager;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final ShareCoordinator shareCoordinator;
    private final SharePartitionManager sharePartitionManager;
    private DynamicConfigPublisher dynamicConfigPublisher;
    private final DynamicClientQuotaPublisher dynamicClientQuotaPublisher;
    private final DynamicTopicClusterQuotaPublisher dynamicTopicClusterQuotaPublisher;
    private final ScramPublisher scramPublisher;
    private final DelegationTokenPublisher delegationTokenPublisher;
    private final AclPublisher aclPublisher;
    private final FaultHandler fatalFaultHandler;
    private final FaultHandler metadataPublishingFaultHandler;
    private final int brokerId;
    private boolean _firstPublish;
    private final CompletableFuture<Void> firstPublishFuture;
    private short finalizedShareVersion;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<TopicDelta> getTopicDelta(String topicName, MetadataImage newImage, MetadataDelta delta) {
        return BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, newImage, delta);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public void onControllerChange(LeaderAndEpoch x$1) {
        super.onControllerChange(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DynamicConfigPublisher dynamicConfigPublisher() {
        return this.dynamicConfigPublisher;
    }

    public void dynamicConfigPublisher_$eq(DynamicConfigPublisher x$1) {
        this.dynamicConfigPublisher = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean _firstPublish() {
        return this._firstPublish;
    }

    public void _firstPublish_$eq(boolean x$1) {
        this._firstPublish = x$1;
    }

    public CompletableFuture<Void> firstPublishFuture() {
        return this.firstPublishFuture;
    }

    private short finalizedShareVersion() {
        return this.finalizedShareVersion;
    }

    private void finalizedShareVersion_$eq(short x$1) {
        this.finalizedShareVersion = x$1;
    }

    public String name() {
        return "BrokerMetadataPublisher";
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        block17: {
            OffsetAndEpoch highestOffsetAndEpoch = newImage.highestOffsetAndEpoch();
            String deltaName = this._firstPublish() ? "initial MetadataDelta up to " + highestOffsetAndEpoch.offset() : "MetadataDelta up to " + highestOffsetAndEpoch.offset();
            try {
                try {
                    if (this.isTraceEnabled()) {
                        this.trace((Function0<String>)(Function0 & Serializable)() -> "Publishing delta " + delta + " with highest offset " + highestOffsetAndEpoch);
                    }
                    this.metadataCache.setImage(newImage);
                    if (this._firstPublish()) {
                        this.info((Function0<String>)(Function0 & Serializable)() -> "Publishing initial metadata at offset " + highestOffsetAndEpoch + " with " + BrokerMetadataPublisher.metadataVersionLogMsg$1(newImage) + ".");
                        this.initializeManagers(newImage);
                    } else if (this.isDebugEnabled()) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> "Publishing metadata at offset " + highestOffsetAndEpoch + " with " + BrokerMetadataPublisher.metadataVersionLogMsg$1(newImage) + ".");
                    }
                    Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable)topicsDelta -> {
                        RuntimeException runtimeException;
                        try {
                            $this.replicaManager.applyDelta((TopicsDelta)topicsDelta, newImage);
                        }
                        catch (Throwable t) {
                            $this.metadataPublishingFaultHandler.handleFault("Error applying topics delta in " + deltaName, t);
                        }
                        try {
                            this.updateCoordinator(newImage, delta, "__consumer_offsets", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(x$1, x$2) -> $this.groupCoordinator.onElection(x$1, x$2), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(partitionIndex, leaderEpochOpt) -> {
                                this.groupCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)partitionIndex), this.toOptionalInt((Option<Object>)leaderEpochOpt));
                                return BoxedUnit.UNIT;
                            });
                        }
                        catch (Throwable t) {
                            $this.metadataPublishingFaultHandler.handleFault("Error updating group coordinator with local changes in " + deltaName, t);
                        }
                        try {
                            this.updateCoordinator(newImage, delta, "__transaction_state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(txnTopicPartitionId, coordinatorEpoch) -> $this.txnCoordinator.onElection(txnTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(txnTopicPartitionId, coordinatorEpoch) -> {
                                this.txnCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)txnTopicPartitionId), (Option<Object>)coordinatorEpoch);
                                return BoxedUnit.UNIT;
                            });
                        }
                        catch (Throwable t) {
                            $this.metadataPublishingFaultHandler.handleFault("Error updating txn coordinator with local changes in " + deltaName, t);
                        }
                        try {
                            this.updateCoordinator(newImage, delta, "__share_group_state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable)(x$1, x$2) -> $this.shareCoordinator.onElection(x$1, x$2), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable)(partitionIndex, leaderEpochOpt) -> {
                                this.shareCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)partitionIndex), this.toOptionalInt((Option<Object>)leaderEpochOpt));
                                return BoxedUnit.UNIT;
                            });
                        }
                        catch (Throwable t) {
                            $this.metadataPublishingFaultHandler.handleFault("Error updating share coordinator with local changes in " + deltaName, t);
                        }
                        try {
                            ArrayBuffer deletedTopicPartitions = new ArrayBuffer();
                            topicsDelta.deletedTopicIds().forEach(id2 -> {
                                TopicImage topicImage = topicsDelta.image().getTopic(id2);
                                topicImage.partitions().keySet().forEach(id -> deletedTopicPartitions.$plus$eq((Object)new TopicPartition(topicImage.name(), Predef$.MODULE$.Integer2int(id))));
                            });
                            if (deletedTopicPartitions.nonEmpty()) {
                                $this.groupCoordinator.onPartitionsDeleted(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)deletedTopicPartitions).asJava(), RequestLocal.noCaching().bufferSupplier());
                            }
                        }
                        catch (Throwable t) {
                            $this.metadataPublishingFaultHandler.handleFault("Error updating group coordinator with deleted partitions in " + deltaName, t);
                        }
                        try {
                            if (topicsDelta.deletedTopicIds().isEmpty()) {
                                return BoxedUnit.UNIT;
                            }
                            $this.shareCoordinator.onTopicsDeleted(topicsDelta.deletedTopicIds(), RequestLocal.noCaching().bufferSupplier());
                            runtimeException = BoxedUnit.UNIT;
                        }
                        catch (Throwable t) {
                            runtimeException = $this.metadataPublishingFaultHandler.handleFault("Error updating share coordinator with deleted partitions in " + deltaName, t);
                        }
                        return runtimeException;
                    });
                    this.dynamicConfigPublisher().onMetadataUpdate(delta, newImage);
                    this.dynamicClientQuotaPublisher.onMetadataUpdate(delta, newImage, manifest);
                    this.dynamicTopicClusterQuotaPublisher.onMetadataUpdate(delta, newImage);
                    this.scramPublisher.onMetadataUpdate(delta, newImage, manifest);
                    this.delegationTokenPublisher.onMetadataUpdate(delta, newImage, manifest);
                    this.aclPublisher.onMetadataUpdate(delta, newImage, manifest);
                    try {
                        this.groupCoordinator.onNewMetadataImage((CoordinatorMetadataImage)new KRaftCoordinatorMetadataImage(newImage), (CoordinatorMetadataDelta)new KRaftCoordinatorMetadataDelta(delta));
                    }
                    catch (Throwable t) {
                        this.metadataPublishingFaultHandler.handleFault("Error updating group coordinator with local changes in " + deltaName, t);
                    }
                    try {
                        this.shareCoordinator.onNewMetadataImage((CoordinatorMetadataImage)new KRaftCoordinatorMetadataImage(newImage), newImage.features(), (CoordinatorMetadataDelta)new KRaftCoordinatorMetadataDelta(delta));
                    }
                    catch (Throwable t) {
                        this.metadataPublishingFaultHandler.handleFault("Error updating share coordinator with local changes in " + deltaName, t);
                    }
                    if (this._firstPublish()) {
                        this.finishInitializingReplicaManager();
                    }
                    if (delta.featuresDelta() == null) break block17;
                    try {
                        Short newFinalizedShareVersion = new FinalizedFeatures(newImage.features().metadataVersionOrThrow(), newImage.features().finalizedVersions(), newImage.provenance().lastContainedOffset()).finalizedFeatures().getOrDefault("share.version", Predef$.MODULE$.short2Short((short)0));
                        if (!BoxesRunTime.equalsNumObject((Number)newFinalizedShareVersion, (Object)BoxesRunTime.boxToShort((short)this.finalizedShareVersion()))) {
                            this.finalizedShareVersion_$eq(Predef$.MODULE$.Short2short(newFinalizedShareVersion));
                            ShareVersion shareVersion = ShareVersion.fromFeatureLevel((short)this.finalizedShareVersion());
                            this.info((Function0<String>)(Function0 & Serializable)() -> "Feature share.version has been updated to version " + this.finalizedShareVersion());
                            this.sharePartitionManager.onShareVersionToggle(shareVersion, this.config.shareGroupConfig().isShareGroupEnabled());
                        }
                    }
                    catch (Throwable t) {
                        this.metadataPublishingFaultHandler.handleFault("Error updating share partition manager  with share version feature change in " + deltaName, t);
                    }
                }
                catch (Throwable t) {
                    this.metadataPublishingFaultHandler.handleFault("Uncaught exception while publishing broker metadata from " + deltaName, t);
                }
            }
            finally {
                this._firstPublish_$eq(false);
                this.firstPublishFuture().complete(null);
            }
        }
    }

    private OptionalInt toOptionalInt(Option<Object> option) {
        if (option instanceof Some) {
            return OptionalInt.of(BoxesRunTime.unboxToInt((Object)((Some)option).value()));
        }
        if (None$.MODULE$.equals(option)) {
            return OptionalInt.empty();
        }
        throw new MatchError(option);
    }

    public void updateCoordinator(MetadataImage image, MetadataDelta delta, String topicName, Function2<Object, Object, BoxedUnit> election, Function2<Object, Option<Object>, BoxedUnit> resignation) {
        Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable)topicsDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$1(this, topicName, resignation, topicsDelta);
            return BoxedUnit.UNIT;
        });
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, image, delta).foreach((Function1 & Serializable)topicDelta -> {
            BrokerMetadataPublisher.$anonfun$updateCoordinator$3(this, resignation, election, topicDelta);
            return BoxedUnit.UNIT;
        });
    }

    private void initializeManagers(MetadataImage newImage) {
        try {
            this.logManager.startup((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(this.metadataCache.getAllTopics()).asScala(), (Function1<UnifiedLog, Object>)(Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)BrokerMetadataPublisher.$anonfun$initializeManagers$1(this, newImage, log)));
            this.logManager.recoverAbandonedFutureLogs(this.brokerId(), newImage.topics());
            Option$.MODULE$.apply((Object)this.logManager.cleaner()).foreach((Function1 & Serializable)reconfigurable -> {
                BrokerMetadataPublisher.$anonfun$initializeManagers$2(this, reconfigurable);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting LogManager", t);
        }
        try {
            this.replicaManager.startup();
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting ReplicaManager", t);
        }
        try {
            this.groupCoordinator.startup(() -> Predef$.MODULE$.Integer2int($this.metadataCache.numPartitions("__consumer_offsets").orElse(Predef$.MODULE$.int2Integer($this.config.groupCoordinatorConfig().offsetsTopicPartitions()))));
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting GroupCoordinator", t);
        }
        try {
            TransactionLogConfig transactionLogConfig = new TransactionLogConfig((AbstractConfig)this.config);
            this.txnCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable)() -> Predef$.MODULE$.Integer2int($this.metadataCache.numPartitions("__transaction_state").orElse(Predef$.MODULE$.int2Integer(transactionLogConfig.transactionTopicPartitions()))), this.txnCoordinator.startup$default$2());
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting TransactionCoordinator", t);
        }
        try {
            this.shareCoordinator.startup(() -> Predef$.MODULE$.Integer2int($this.metadataCache.numPartitions("__share_group_state").orElse(Predef$.MODULE$.int2Integer($this.config.shareCoordinatorConfig().shareCoordinatorStateTopicNumPartitions()))));
            return;
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting Share coordinator", t);
            return;
        }
    }

    private void finishInitializingReplicaManager() {
        try {
            this.replicaManager.startHighWatermarkCheckPointThread();
            return;
        }
        catch (Throwable t) {
            this.metadataPublishingFaultHandler.handleFault("Error starting high watermark checkpoint thread during startup", t);
            return;
        }
    }

    public void close() {
        this.firstPublishFuture().completeExceptionally((Throwable)new TimeoutException());
    }

    private static final String metadataVersionLogMsg$1(MetadataImage newImage$1) {
        return "metadata.version " + newImage$1.features().metadataVersion();
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$1(BrokerMetadataPublisher $this, String topicName$1, Function2 resignation$1, TopicsDelta topicsDelta) {
        if (topicsDelta.topicWasDeleted(topicName$1)) {
            topicsDelta.image().getTopic(topicName$1).partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == $this.brokerId()) {
                    resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)entry.getKey())), (Object)None$.MODULE$);
                    return;
                }
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$3(BrokerMetadataPublisher $this, Function2 resignation$1, Function2 election$1, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)None$.MODULE$));
        changes.electedLeaders().forEach((topicPartition, partitionInfo) -> election$1.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> resignation$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ boolean $anonfun$initializeManagers$1(BrokerMetadataPublisher $this, MetadataImage newImage$2, UnifiedLog log) {
        return LogManager.isStrayKraftReplica((int)$this.brokerId(), (TopicsImage)newImage$2.topics(), (UnifiedLog)log);
    }

    public static final /* synthetic */ void $anonfun$initializeManagers$2(BrokerMetadataPublisher $this, BrokerReconfigurable reconfigurable) {
        $this.config.dynamicConfig().addBrokerReconfigurable(reconfigurable);
    }

    public BrokerMetadataPublisher(KafkaConfig config, KRaftMetadataCache metadataCache, kafka.log.LogManager logManager, ReplicaManager replicaManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, ShareCoordinator shareCoordinator, SharePartitionManager sharePartitionManager, DynamicConfigPublisher dynamicConfigPublisher, DynamicClientQuotaPublisher dynamicClientQuotaPublisher, DynamicTopicClusterQuotaPublisher dynamicTopicClusterQuotaPublisher, ScramPublisher scramPublisher, DelegationTokenPublisher delegationTokenPublisher, AclPublisher aclPublisher, FaultHandler fatalFaultHandler, FaultHandler metadataPublishingFaultHandler) {
        this.config = config;
        this.metadataCache = metadataCache;
        this.logManager = logManager;
        this.replicaManager = replicaManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.shareCoordinator = shareCoordinator;
        this.sharePartitionManager = sharePartitionManager;
        this.dynamicConfigPublisher = dynamicConfigPublisher;
        this.dynamicClientQuotaPublisher = dynamicClientQuotaPublisher;
        this.dynamicTopicClusterQuotaPublisher = dynamicTopicClusterQuotaPublisher;
        this.scramPublisher = scramPublisher;
        this.delegationTokenPublisher = delegationTokenPublisher;
        this.aclPublisher = aclPublisher;
        this.fatalFaultHandler = fatalFaultHandler;
        this.metadataPublishingFaultHandler = metadataPublishingFaultHandler;
        this.logIdent_$eq("[BrokerMetadataPublisher id=" + config.nodeId() + "] ");
        this.brokerId = config.nodeId();
        this._firstPublish = true;
        this.firstPublishFuture = new CompletableFuture();
        this.finalizedShareVersion = Predef$.MODULE$.Short2short(FinalizedFeatures.fromKRaftVersion((MetadataVersion)MetadataVersion.MINIMUM_VERSION).finalizedFeatures().getOrDefault("share.version", Predef$.MODULE$.short2Short((short)0)));
    }
}

