/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Objects;

public abstract class BackgroundEvent {
    private final Type type;
    private long enqueuedMs;

    protected BackgroundEvent(Type type) {
        this.type = Objects.requireNonNull(type);
    }

    public Type type() {
        return this.type;
    }

    public void setEnqueuedMs(long enqueuedMs) {
        this.enqueuedMs = enqueuedMs;
    }

    public long enqueuedMs() {
        return this.enqueuedMs;
    }

    protected String toStringBase() {
        return "type=" + String.valueOf((Object)this.type) + ", enqueuedMs=" + this.enqueuedMs;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "{" + this.toStringBase() + "}";
    }

    public static enum Type {
        ERROR,
        CONSUMER_REBALANCE_LISTENER_CALLBACK_NEEDED,
        STREAMS_ON_TASKS_ASSIGNED_CALLBACK_NEEDED,
        STREAMS_ON_TASKS_REVOKED_CALLBACK_NEEDED,
        STREAMS_ON_ALL_TASKS_LOST_CALLBACK_NEEDED;

    }
}

