/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.publisher;

import java.util.Map;
import java.util.Optional;
import org.apache.kafka.image.DelegationTokenImage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.DelegationTokenData;
import org.apache.kafka.security.DelegationTokenManager;
import org.apache.kafka.server.fault.FaultHandler;

public class DelegationTokenPublisher
implements MetadataPublisher {
    private final int nodeId;
    private final FaultHandler faultHandler;
    private final String nodeType;
    private final DelegationTokenManager tokenManager;
    private boolean firstPublish = true;

    public DelegationTokenPublisher(int nodeId, FaultHandler faultHandler, String nodeType, DelegationTokenManager tokenManager) {
        this.nodeId = nodeId;
        this.faultHandler = faultHandler;
        this.nodeType = nodeType;
        this.tokenManager = tokenManager;
    }

    @Override
    public final String name() {
        return "DelegationTokenPublisher " + this.nodeType + " id=" + this.nodeId;
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        boolean first = this.firstPublish;
        try {
            if (this.firstPublish) {
                DelegationTokenImage delegationTokenImage = newImage.delegationTokens();
                for (Map.Entry<String, DelegationTokenData> token : delegationTokenImage.tokens().entrySet()) {
                    this.tokenManager.updateToken(this.tokenManager.getDelegationToken(token.getValue().tokenInformation()));
                }
                this.firstPublish = false;
            }
            for (Map.Entry entry : delta.getOrCreateDelegationTokenDelta().changes().entrySet()) {
                String tokenId = (String)entry.getKey();
                Optional delegationTokenData = (Optional)entry.getValue();
                if (delegationTokenData.isPresent()) {
                    this.tokenManager.updateToken(this.tokenManager.getDelegationToken(((DelegationTokenData)delegationTokenData.get()).tokenInformation()));
                    continue;
                }
                this.tokenManager.removeToken(tokenId);
            }
        }
        catch (Throwable t) {
            String string = String.format("Uncaught exception while publishing DelegationToken changes from %s MetadataDelta up to %s", first ? "initial" : "update", newImage.highestOffsetAndEpoch().offset());
            this.faultHandler.handleFault(string, t);
        }
    }
}

