/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.storage;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.distributed.DistributedConfig;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.KafkaTopicBasedBackingStore;
import org.apache.kafka.connect.storage.OffsetBackingStore;
import org.apache.kafka.connect.storage.OffsetUtils;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectUtils;
import org.apache.kafka.connect.util.ConvertingFutureCallback;
import org.apache.kafka.connect.util.KafkaBasedLog;
import org.apache.kafka.connect.util.TopicAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaOffsetBackingStore
extends KafkaTopicBasedBackingStore
implements OffsetBackingStore {
    private static final Logger log = LoggerFactory.getLogger(KafkaOffsetBackingStore.class);
    protected KafkaBasedLog<byte[], byte[]> offsetLog;
    final HashMap<ByteBuffer, ByteBuffer> data = new HashMap();
    private final Map<String, Set<Map<String, Object>>> connectorPartitions = new HashMap<String, Set<Map<String, Object>>>();
    private Converter keyConverter;
    private final Supplier<TopicAdmin> topicAdminSupplier;
    private final Supplier<String> clientIdBase;
    protected boolean exactlyOnce;
    protected final Callback<ConsumerRecord<byte[], byte[]>> consumedCallback = (error, record) -> {
        ByteBuffer key;
        if (error != null) {
            log.error("Failed to read from the offsets topic", error);
            return;
        }
        OffsetUtils.processPartitionKey((byte[])record.key(), (byte[])record.value(), this.keyConverter, this.connectorPartitions);
        ByteBuffer byteBuffer = key = record.key() != null ? ByteBuffer.wrap((byte[])record.key()) : null;
        if (record.value() == null) {
            this.data.remove(key);
        } else {
            this.data.put(key, ByteBuffer.wrap((byte[])record.value()));
        }
    };

    public static KafkaOffsetBackingStore readWriteStore(final String topic, final Producer<byte[], byte[]> producer, final Consumer<byte[], byte[]> consumer, final TopicAdmin topicAdmin, Converter keyConverter) {
        return new KafkaOffsetBackingStore(() -> topicAdmin, KafkaOffsetBackingStore::noClientId, keyConverter){

            @Override
            public void configure(WorkerConfig config) {
                this.exactlyOnce = config.exactlyOnceSourceEnabled();
                this.offsetLog = KafkaBasedLog.withExistingClients(topic, consumer, producer, topicAdmin, this.consumedCallback, Time.SYSTEM, this.topicInitializer(topic, this.newTopicDescription(topic, config), config, Time.SYSTEM), ignored -> true);
            }
        };
    }

    public static KafkaOffsetBackingStore readOnlyStore(final String topic, final Consumer<byte[], byte[]> consumer, final TopicAdmin topicAdmin, Converter keyConverter) {
        return new KafkaOffsetBackingStore(() -> topicAdmin, KafkaOffsetBackingStore::noClientId, keyConverter){

            @Override
            public void configure(WorkerConfig config) {
                this.exactlyOnce = config.exactlyOnceSourceEnabled();
                this.offsetLog = KafkaBasedLog.withExistingClients(topic, consumer, null, topicAdmin, this.consumedCallback, Time.SYSTEM, this.topicInitializer(topic, this.newTopicDescription(topic, config), config, Time.SYSTEM), ignored -> true);
            }
        };
    }

    private static String noClientId() {
        throw new UnsupportedOperationException("This offset store should not instantiate any Kafka clients");
    }

    public KafkaOffsetBackingStore(Supplier<TopicAdmin> topicAdmin, Supplier<String> clientIdBase, Converter keyConverter) {
        this.topicAdminSupplier = Objects.requireNonNull(topicAdmin);
        this.clientIdBase = Objects.requireNonNull(clientIdBase);
        this.keyConverter = keyConverter;
    }

    @Override
    public void configure(WorkerConfig config) {
        String topic = config.getString("offset.storage.topic");
        if (topic == null || topic.trim().isEmpty()) {
            throw new ConfigException("Offset storage topic must be specified");
        }
        this.exactlyOnce = config.exactlyOnceSourceEnabled();
        String clusterId = config.kafkaClusterId();
        String clientId = Objects.requireNonNull(this.clientIdBase.get()) + "offsets";
        Map<String, Object> originals = config.originals();
        HashMap<String, Object> producerProps = new HashMap<String, Object>(originals);
        producerProps.put("key.serializer", ByteArraySerializer.class.getName());
        producerProps.put("value.serializer", ByteArraySerializer.class.getName());
        producerProps.put("delivery.timeout.ms", Integer.MAX_VALUE);
        producerProps.put("enable.idempotence", "false");
        producerProps.put("client.id", clientId);
        ConnectUtils.addMetricsContextProperties(producerProps, config, clusterId);
        HashMap<String, Object> consumerProps = new HashMap<String, Object>(originals);
        consumerProps.put("key.deserializer", ByteArrayDeserializer.class.getName());
        consumerProps.put("value.deserializer", ByteArrayDeserializer.class.getName());
        consumerProps.put("client.id", clientId);
        ConnectUtils.addMetricsContextProperties(consumerProps, config, clusterId);
        if (config.exactlyOnceSourceEnabled()) {
            ConnectUtils.ensureProperty(consumerProps, "isolation.level", IsolationLevel.READ_COMMITTED.toString(), "for the worker offsets topic consumer when exactly-once source support is enabled", false);
        }
        HashMap<String, Object> adminProps = new HashMap<String, Object>(originals);
        adminProps.put("client.id", clientId);
        ConnectUtils.addMetricsContextProperties(adminProps, config, clusterId);
        NewTopic topicDescription = this.newTopicDescription(topic, config);
        this.offsetLog = this.createKafkaBasedLog(topic, producerProps, consumerProps, this.consumedCallback, topicDescription, this.topicAdminSupplier, config, Time.SYSTEM);
    }

    protected NewTopic newTopicDescription(String topic, WorkerConfig config) {
        Map<String, Object> topicSettings = config instanceof DistributedConfig ? ((DistributedConfig)config).offsetStorageTopicSettings() : Map.of();
        return TopicAdmin.defineTopic(topic).config(topicSettings).compacted().partitions(config.getInt("offset.storage.partitions")).replicationFactor(config.getShort("offset.storage.replication.factor")).build();
    }

    @Override
    public void start() {
        log.info("Starting KafkaOffsetBackingStore");
        try {
            this.offsetLog.start();
        }
        catch (UnsupportedVersionException e) {
            Object message = this.exactlyOnce ? "Enabling exactly-once support for source connectors requires a Kafka broker version that allows admin clients to read consumer offsets. Please either disable the worker's exactly-once support for source connectors, or upgrade to a newer Kafka broker version." : "When isolation.levelis set to " + String.valueOf(IsolationLevel.READ_COMMITTED) + ", a Kafka broker version that allows admin clients to read consumer offsets is required. Please either reconfigure the worker or connector, or upgrade to a newer Kafka broker version.";
            throw new ConnectException((String)message, (Throwable)e);
        }
        log.info("Finished reading offsets topic and starting KafkaOffsetBackingStore");
    }

    @Override
    public void stop() {
        log.info("Stopping KafkaOffsetBackingStore");
        this.offsetLog.stop();
        log.info("Stopped KafkaOffsetBackingStore");
    }

    @Override
    public Future<Map<ByteBuffer, ByteBuffer>> get(final Collection<ByteBuffer> keys) {
        ConvertingFutureCallback<Void, Map<ByteBuffer, ByteBuffer>> future = new ConvertingFutureCallback<Void, Map<ByteBuffer, ByteBuffer>>(this){
            final /* synthetic */ KafkaOffsetBackingStore this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Map<ByteBuffer, ByteBuffer> convert(Void result) {
                HashMap<ByteBuffer, ByteBuffer> values = new HashMap<ByteBuffer, ByteBuffer>();
                for (ByteBuffer key : keys) {
                    values.put(key, this.this$0.data.get(key));
                }
                return values;
            }
        };
        this.offsetLog.readToEnd((Callback<Void>)future);
        return future;
    }

    @Override
    public Future<Void> set(Map<ByteBuffer, ByteBuffer> values, Callback<Void> callback) {
        SetCallbackFuture producerCallback = new SetCallbackFuture(values.size(), callback);
        for (Map.Entry<ByteBuffer, ByteBuffer> entry : values.entrySet()) {
            ByteBuffer key = entry.getKey();
            ByteBuffer value = entry.getValue();
            this.offsetLog.send(key == null ? null : key.array(), value == null ? null : value.array(), producerCallback);
        }
        return producerCallback;
    }

    @Override
    public Set<Map<String, Object>> connectorPartitions(String connectorName) {
        return this.connectorPartitions.getOrDefault(connectorName, Set.of());
    }

    @Override
    protected String getTopicConfig() {
        return "offset.storage.topic";
    }

    @Override
    protected String getTopicPurpose() {
        return "source connector offsets";
    }

    private static class SetCallbackFuture
    implements org.apache.kafka.clients.producer.Callback,
    Future<Void> {
        private int numLeft;
        private boolean completed = false;
        private Throwable exception = null;
        private final Callback<Void> callback;

        public SetCallbackFuture(int numRecords, Callback<Void> callback) {
            this.numLeft = numRecords;
            this.callback = callback;
        }

        public synchronized void onCompletion(RecordMetadata metadata, Exception exception) {
            if (exception != null) {
                if (!this.completed) {
                    this.exception = exception;
                    this.callback.onCompletion(exception, null);
                    this.completed = true;
                    this.notify();
                }
                return;
            }
            --this.numLeft;
            if (this.numLeft == 0) {
                this.callback.onCompletion(null, null);
                this.completed = true;
                this.notify();
            }
        }

        @Override
        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public synchronized boolean isCancelled() {
            return false;
        }

        @Override
        public synchronized boolean isDone() {
            return this.completed;
        }

        @Override
        public synchronized Void get() throws InterruptedException, ExecutionException {
            while (!this.completed) {
                this.wait();
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return null;
        }

        @Override
        public synchronized Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long started = System.currentTimeMillis();
            long limit = started + unit.toMillis(timeout);
            while (!this.completed) {
                long leftMs = limit - System.currentTimeMillis();
                if (leftMs < 0L) {
                    throw new TimeoutException("KafkaOffsetBackingStore Future timed out.");
                }
                this.wait(leftMs);
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return null;
        }
    }
}

