/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.consumer.AcknowledgementCommitCallback;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaShareConsumer;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.coordinator.group.ShareGroupAutoOffsetResetStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifiableShareConsumer
implements Closeable,
AcknowledgementCommitCallback {
    private static final Logger log = LoggerFactory.getLogger(VerifiableShareConsumer.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final PrintStream out;
    private final KafkaShareConsumer<String, String> consumer;
    private final Admin adminClient;
    private final String topic;
    private final AcknowledgementMode acknowledgementMode;
    private final String offsetResetStrategy;
    private final Boolean verbose;
    private final int maxMessages;
    private Integer totalAcknowledged = 0;
    private final String groupId;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);

    public VerifiableShareConsumer(KafkaShareConsumer<String, String> consumer, Admin adminClient, PrintStream out, Integer maxMessages, String topic, AcknowledgementMode acknowledgementMode, String offsetResetStrategy, String groupId, Boolean verbose) {
        this.out = out;
        this.consumer = consumer;
        this.adminClient = adminClient;
        this.topic = topic;
        this.acknowledgementMode = acknowledgementMode;
        this.offsetResetStrategy = offsetResetStrategy;
        this.verbose = verbose;
        this.maxMessages = maxMessages;
        this.groupId = groupId;
        this.addKafkaSerializerModule();
    }

    private void addKafkaSerializerModule() {
        SimpleModule kafka = new SimpleModule();
        kafka.addSerializer(TopicPartition.class, (JsonSerializer)new JsonSerializer<TopicPartition>(){

            public void serialize(TopicPartition tp, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeStartObject();
                gen.writeObjectField("topic", (Object)tp.topic());
                gen.writeObjectField("partition", (Object)tp.partition());
                gen.writeEndObject();
            }
        });
        this.mapper.registerModule((Module)kafka);
    }

    private void onRecordsReceived(ConsumerRecords<String, String> records) {
        ArrayList<RecordSetSummary> summaries = new ArrayList<RecordSetSummary>();
        for (TopicPartition tp : records.partitions()) {
            List partitionRecords = records.records(tp);
            if (partitionRecords.isEmpty()) continue;
            TreeSet<Long> partitionOffsets = new TreeSet<Long>();
            for (ConsumerRecord record : partitionRecords) {
                partitionOffsets.add(record.offset());
            }
            summaries.add(new RecordSetSummary(tp.topic(), tp.partition(), partitionOffsets));
            if (!this.verbose.booleanValue()) continue;
            for (ConsumerRecord record : partitionRecords) {
                this.printJson(new RecordData((ConsumerRecord<String, String>)record));
            }
        }
        this.printJson(new RecordsConsumed(records.count(), summaries));
    }

    public void onComplete(Map<TopicIdPartition, Set<Long>> offsetsMap, Exception exception) {
        ArrayList<AcknowledgedData> acknowledgedOffsets = new ArrayList<AcknowledgedData>();
        int totalAcknowledged = 0;
        for (Map.Entry<TopicIdPartition, Set<Long>> offsetEntry : offsetsMap.entrySet()) {
            TopicIdPartition tp = offsetEntry.getKey();
            acknowledgedOffsets.add(new AcknowledgedData(tp.topic(), tp.partition(), offsetEntry.getValue()));
            totalAcknowledged += offsetEntry.getValue().size();
        }
        boolean success = true;
        String error = null;
        if (exception != null) {
            success = false;
            error = exception.getMessage();
        }
        this.printJson(new OffsetsAcknowledged(totalAcknowledged, acknowledgedOffsets, error, success));
        if (success) {
            this.totalAcknowledged = this.totalAcknowledged + totalAcknowledged;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.printJson(new StartupComplete());
            if (!Objects.equals(this.offsetResetStrategy, "")) {
                ShareGroupAutoOffsetResetStrategy offsetResetStrategy = ShareGroupAutoOffsetResetStrategy.fromString((String)this.offsetResetStrategy);
                ConfigResource configResource = new ConfigResource(ConfigResource.Type.GROUP, this.groupId);
                HashMap<ConfigResource, List<AlterConfigOp>> alterEntries = new HashMap<ConfigResource, List<AlterConfigOp>>();
                alterEntries.put(configResource, List.of(new AlterConfigOp(new ConfigEntry("share.auto.offset.reset", offsetResetStrategy.type().toString()), AlterConfigOp.OpType.SET)));
                AlterConfigsOptions alterOptions = new AlterConfigsOptions();
                this.adminClient.incrementalAlterConfigs(alterEntries, alterOptions).all().get(60L, TimeUnit.SECONDS);
                this.printJson(new OffsetResetStrategySet(offsetResetStrategy.type().toString()));
            }
            this.consumer.subscribe(Set.of(this.topic));
            this.consumer.setAcknowledgementCommitCallback((AcknowledgementCommitCallback)this);
            while (this.maxMessages < 0 || this.totalAcknowledged < this.maxMessages) {
                ConsumerRecords records = this.consumer.poll(Duration.ofMillis(5000L));
                if (records.isEmpty()) continue;
                this.onRecordsReceived((ConsumerRecords<String, String>)records);
                if (this.acknowledgementMode == AcknowledgementMode.ASYNC) {
                    this.consumer.commitAsync();
                    continue;
                }
                if (this.acknowledgementMode != AcknowledgementMode.SYNC) continue;
                Map result = this.consumer.commitSync();
                for (Map.Entry resultEntry : result.entrySet()) {
                    if (!((Optional)resultEntry.getValue()).isPresent()) continue;
                    log.error("Failed to commit offset synchronously for topic partition: {}", resultEntry.getKey());
                }
            }
        }
        catch (WakeupException e) {
            log.trace("Caught WakeupException because share consumer is shutdown, ignore and terminate.", (Throwable)e);
        }
        catch (Throwable t) {
            log.error("Error during processing, terminating share consumer process: ", t);
        }
        finally {
            this.consumer.close();
            this.printJson(new ShutdownComplete());
            this.shutdownLatch.countDown();
        }
    }

    @Override
    public void close() {
        boolean interrupted = false;
        try {
            this.consumer.wakeup();
            while (true) {
                try {
                    this.shutdownLatch.await();
                    return;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected synchronized void printJson(Object data) {
        try {
            this.out.println(this.mapper.writeValueAsString(data));
        }
        catch (JsonProcessingException e) {
            this.out.println("Bad data can't be written as json: " + e.getMessage());
        }
    }

    private static ArgumentParser argParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"verifiable-share-consumer").defaultHelp(true).description("This tool creates a share group and consumes messages from a specific topic and emits share consumer events (e.g. share consumer startup, received messages, and offsets acknowledged) as JSON objects to STDOUT.");
        MutuallyExclusiveGroup connectionGroup = parser.addMutuallyExclusiveGroup("Connection Group").description("Group of arguments for connection to brokers").required(true);
        connectionGroup.addArgument(new String[]{"--bootstrap-server"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("bootstrapServer").metavar(new String[]{"HOST1:PORT1[,HOST2:PORT2[...]]"}).help("The server(s) to connect to. Comma-separated list of Kafka brokers in the form HOST1:PORT1,HOST2:PORT2,...");
        parser.addArgument(new String[]{"--topic"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).metavar(new String[]{"TOPIC"}).help("Consumes messages from this topic.");
        parser.addArgument(new String[]{"--group-id"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("groupId").metavar(new String[]{"GROUP-ID"}).help("The group id of the share group");
        parser.addArgument(new String[]{"--max-messages"}).action((ArgumentAction)Arguments.store()).required(false).type(Integer.class).setDefault((Object)-1).dest("maxMessages").metavar(new String[]{"MAX-MESSAGES"}).help("Consume this many messages. If -1 (the default), the share consumers will consume until the process is killed externally");
        parser.addArgument(new String[]{"--verbose"}).action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).metavar(new String[]{"VERBOSE"}).help("Enable to log individual consumed records");
        parser.addArgument(new String[]{"--acknowledgement-mode"}).action((ArgumentAction)Arguments.store()).required(false).setDefault((Object)"auto").type(String.class).dest("acknowledgementMode").metavar(new String[]{"ACKNOWLEDGEMENT-MODE"}).help("Acknowledgement mode for the share consumers (must be either 'auto', 'sync' or 'async')");
        parser.addArgument(new String[]{"--offset-reset-strategy"}).action((ArgumentAction)Arguments.store()).required(false).setDefault((Object)"").type(String.class).dest("offsetResetStrategy").metavar(new String[]{"OFFSET-RESET-STRATEGY"}).help("Share group offset reset strategy (must be either 'earliest' or 'latest')");
        parser.addArgument(new String[]{"--command-config"}).action((ArgumentAction)Arguments.store()).required(false).type(String.class).dest("commandConfig").metavar(new String[]{"CONFIG-FILE"}).help("Config properties file (config options shared with command line parameters will be overridden).");
        return parser;
    }

    public static VerifiableShareConsumer createFromArgs(ArgumentParser parser, String[] args) throws ArgumentParserException {
        Namespace res = parser.parseArgs(args);
        AcknowledgementMode acknowledgementMode = AcknowledgementMode.valueOf(res.getString("acknowledgementMode").toUpperCase(Locale.ROOT));
        String offsetResetStrategy = res.getString("offsetResetStrategy").toLowerCase(Locale.ROOT);
        String configFile = res.getString("commandConfig");
        String brokerHostAndPort = res.getString("bootstrapServer");
        Properties consumerProps = new Properties();
        if (configFile != null) {
            try {
                consumerProps.putAll((Map<?, ?>)Utils.loadProps((String)configFile));
            }
            catch (IOException e) {
                throw new ArgumentParserException(e.getMessage(), parser);
            }
        }
        String groupId = res.getString("groupId");
        consumerProps.put("group.id", groupId);
        consumerProps.put("bootstrap.servers", brokerHostAndPort);
        String topic = res.getString("topic");
        int maxMessages = res.getInt("maxMessages");
        boolean verbose = res.getBoolean("verbose");
        StringDeserializer deserializer = new StringDeserializer();
        KafkaShareConsumer consumer = new KafkaShareConsumer(consumerProps, (Deserializer)deserializer, (Deserializer)deserializer);
        Properties adminClientProps = new Properties();
        if (configFile != null) {
            try {
                adminClientProps.putAll((Map<?, ?>)Utils.loadProps((String)configFile));
            }
            catch (IOException e) {
                throw new ArgumentParserException(e.getMessage(), parser);
            }
        }
        adminClientProps.put("bootstrap.servers", brokerHostAndPort);
        Admin adminClient = Admin.create((Properties)adminClientProps);
        return new VerifiableShareConsumer((KafkaShareConsumer<String, String>)consumer, adminClient, System.out, maxMessages, topic, acknowledgementMode, offsetResetStrategy, groupId, verbose);
    }

    public static void main(String[] args) {
        ArgumentParser parser = VerifiableShareConsumer.argParser();
        if (args.length == 0) {
            parser.printHelp();
            System.exit(0);
        }
        try {
            VerifiableShareConsumer shareConsumer = VerifiableShareConsumer.createFromArgs(parser, args);
            Runtime.getRuntime().addShutdownHook(new Thread(shareConsumer::close, "verifiable-share-consumer-shutdown-hook"));
            shareConsumer.run();
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.exit(1);
        }
    }

    public static enum AcknowledgementMode {
        AUTO,
        ASYNC,
        SYNC;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }

    public static class RecordSetSummary
    extends PartitionData {
        private final long count;
        private final Set<Long> offsets;

        public RecordSetSummary(String topic, int partition, Set<Long> offsets) {
            super(topic, partition);
            this.offsets = offsets;
            this.count = offsets.size();
        }

        @JsonProperty
        public long count() {
            return this.count;
        }

        @JsonProperty
        public Set<Long> offsets() {
            return this.offsets;
        }
    }

    @JsonPropertyOrder(value={"timestamp", "name", "key", "value", "topic", "partition", "offset"})
    public static class RecordData
    extends ShareConsumerEvent {
        private final ConsumerRecord<String, String> record;

        public RecordData(ConsumerRecord<String, String> record) {
            this.record = record;
        }

        @Override
        public String name() {
            return "record_data";
        }

        @JsonProperty
        public String topic() {
            return this.record.topic();
        }

        @JsonProperty
        public int partition() {
            return this.record.partition();
        }

        @JsonProperty
        public String key() {
            return (String)this.record.key();
        }

        @JsonProperty
        public String value() {
            return (String)this.record.value();
        }

        @JsonProperty
        public long offset() {
            return this.record.offset();
        }
    }

    @JsonPropertyOrder(value={"timestamp", "name", "count", "partitions"})
    public static class RecordsConsumed
    extends ShareConsumerEvent {
        private final long count;
        private final List<RecordSetSummary> partitionSummaries;

        public RecordsConsumed(long count, List<RecordSetSummary> partitionSummaries) {
            this.count = count;
            this.partitionSummaries = partitionSummaries;
        }

        @Override
        public String name() {
            return "records_consumed";
        }

        @JsonProperty
        public long count() {
            return this.count;
        }

        @JsonProperty
        public List<RecordSetSummary> partitions() {
            return this.partitionSummaries;
        }
    }

    protected static class AcknowledgedData
    extends PartitionData {
        private final long count;
        private final Set<Long> offsets;

        public AcknowledgedData(String topic, int partition, Set<Long> offsets) {
            super(topic, partition);
            this.offsets = offsets;
            this.count = offsets.size();
        }

        @JsonProperty
        public long count() {
            return this.count;
        }

        @JsonProperty
        public Set<Long> offsets() {
            return this.offsets;
        }
    }

    @JsonPropertyOrder(value={"timestamp", "name", "count", "partitions", "success", "error"})
    protected static class OffsetsAcknowledged
    extends ShareConsumerEvent {
        private final long count;
        private final List<AcknowledgedData> partitions;
        private final String error;
        private final boolean success;

        public OffsetsAcknowledged(long count, List<AcknowledgedData> partitions, String error, boolean success) {
            this.count = count;
            this.partitions = partitions;
            this.error = error;
            this.success = success;
        }

        @Override
        public String name() {
            return "offsets_acknowledged";
        }

        @JsonProperty
        public long count() {
            return this.count;
        }

        @JsonProperty
        public List<AcknowledgedData> partitions() {
            return this.partitions;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public String error() {
            return this.error;
        }

        @JsonProperty
        public boolean success() {
            return this.success;
        }
    }

    protected static class StartupComplete
    extends ShareConsumerEvent {
        protected StartupComplete() {
        }

        @Override
        public String name() {
            return "startup_complete";
        }
    }

    @JsonPropertyOrder(value={"timestamp", "name", "offsetResetStrategy"})
    protected static class OffsetResetStrategySet
    extends ShareConsumerEvent {
        private final String offsetResetStrategy;

        public OffsetResetStrategySet(String offsetResetStrategy) {
            this.offsetResetStrategy = offsetResetStrategy;
        }

        @Override
        public String name() {
            return "offset_reset_strategy_set";
        }

        @JsonProperty
        public String offsetResetStrategy() {
            return this.offsetResetStrategy;
        }
    }

    protected static class ShutdownComplete
    extends ShareConsumerEvent {
        protected ShutdownComplete() {
        }

        @Override
        public String name() {
            return "shutdown_complete";
        }
    }

    @JsonPropertyOrder(value={"timestamp", "name"})
    private static abstract class ShareConsumerEvent {
        private final long timestamp = System.currentTimeMillis();

        private ShareConsumerEvent() {
        }

        @JsonProperty
        public abstract String name();

        @JsonProperty
        public long timestamp() {
            return this.timestamp;
        }
    }

    public static class PartitionData {
        private final String topic;
        private final int partition;

        public PartitionData(String topic, int partition) {
            this.topic = topic;
            this.partition = partition;
        }

        @JsonProperty
        public String topic() {
            return this.topic;
        }

        @JsonProperty
        public int partition() {
            return this.partition;
        }
    }
}

