/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.internals.AbstractConfigurableStoreFactory;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.StoreFactory;
import org.apache.kafka.streams.state.StoreSupplier;

public abstract class MaterializedStoreFactory<K, V, S extends StateStore>
extends AbstractConfigurableStoreFactory {
    protected final MaterializedInternal<K, V, S> materialized;

    public MaterializedStoreFactory(MaterializedInternal<K, V, S> materialized) {
        super(materialized.dslStoreSuppliers().orElse(null));
        this.materialized = materialized;
    }

    @Override
    public boolean loggingEnabled() {
        return this.materialized.loggingEnabled();
    }

    @Override
    public String storeName() {
        return this.materialized.storeName();
    }

    public String queryableStoreName() {
        return this.materialized.queryableStoreName();
    }

    public Serde<K> keySerde() {
        return this.materialized.keySerde();
    }

    public Serde<V> valueSerde() {
        return this.materialized.valueSerde();
    }

    public StoreSupplier<S> storeSupplier() {
        return this.materialized.storeSupplier();
    }

    @Override
    public Map<String, String> logConfig() {
        return this.materialized.logConfig();
    }

    @Override
    public StoreFactory withCachingDisabled() {
        this.materialized.withCachingDisabled();
        return this;
    }

    @Override
    public StoreFactory withLoggingDisabled() {
        this.materialized.withLoggingDisabled();
        return this;
    }

    @Override
    public boolean isCompatibleWith(StoreFactory storeFactory) {
        return storeFactory instanceof MaterializedStoreFactory && ((MaterializedStoreFactory)storeFactory).materialized.equals(this.materialized);
    }
}

